/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import livegps.LiveGpsAcquirer;
import livegps.LiveGpsLayer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.RawGpsLayer;
import org.openstreetmap.josm.plugins.Plugin;

public class LiveGpsPlugin
extends Plugin {
    private LiveGpsAcquirer acquirer = null;
    private Thread acquirerThread = null;
    private JMenu lgpsmenu;
    private JCheckBoxMenuItem lgpscapture;
    private JMenuItem lgpscenter;
    private JCheckBoxMenuItem lgpsautocenter;
    private Collection<Collection<RawGpsLayer.GpsPoint>> data = new ArrayList<Collection<RawGpsLayer.GpsPoint>>();
    private LiveGpsLayer lgpslayer;

    public LiveGpsPlugin() {
        MainMenu mainMenu = Main.main.menu;
        this.lgpsmenu = new JMenu("LiveGPS");
        mainMenu.add((Component)this.lgpsmenu, 2);
        this.lgpscapture = new JCheckBoxMenuItem("Capture GPS Track");
        this.lgpscapture.setSelected(false);
        this.lgpscapture.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (LiveGpsPlugin.this.acquirer != null && !LiveGpsPlugin.this.lgpscapture.isSelected()) {
                    LiveGpsPlugin.this.acquirer.shutdown();
                    LiveGpsPlugin.this.acquirer = null;
                    LiveGpsPlugin.this.acquirerThread = null;
                } else if (LiveGpsPlugin.this.acquirer == null && LiveGpsPlugin.this.lgpscapture.isSelected()) {
                    LiveGpsPlugin.this.acquirer = new LiveGpsAcquirer();
                    if (LiveGpsPlugin.this.lgpslayer == null) {
                        LiveGpsPlugin.this.lgpslayer = new LiveGpsLayer(LiveGpsPlugin.this.data);
                        Main.main.addLayer((Layer)LiveGpsPlugin.this.lgpslayer);
                    }
                    LiveGpsPlugin.this.acquirer.setOutputLayer(LiveGpsPlugin.this.lgpslayer);
                    LiveGpsPlugin.this.acquirerThread = new Thread(LiveGpsPlugin.this.acquirer);
                    LiveGpsPlugin.this.acquirerThread.start();
                }
            }
        });
        this.lgpsmenu.add(this.lgpscapture);
        this.lgpscenter = new JMenuItem("Center Once", 67);
        this.lgpscenter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LiveGpsPlugin.this.lgpslayer.center();
            }
        });
        this.lgpsmenu.add(this.lgpscenter);
        this.lgpsautocenter = new JCheckBoxMenuItem("Auto-Center on current position");
        this.lgpsautocenter.setSelected(false);
        this.lgpsautocenter.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LiveGpsPlugin.this.lgpslayer.setAutoCenter(LiveGpsPlugin.this.lgpsautocenter.isSelected());
                if (LiveGpsPlugin.this.lgpsautocenter.isSelected()) {
                    LiveGpsPlugin.this.lgpslayer.center();
                }
            }
        });
        this.lgpsmenu.add(this.lgpsautocenter);
    }
}

