/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.JLabel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.RawGpsLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveGpsLayer
extends RawGpsLayer {
    LatLon lastPos;
    RawGpsLayer.GpsPoint lastPoint;
    Collection<RawGpsLayer.GpsPoint> trackBeingWritten;
    float speed;
    float course;
    String status;
    JLabel lbl;
    boolean autocenter;

    public LiveGpsLayer(Collection<Collection<RawGpsLayer.GpsPoint>> collection) {
        super(collection, "LiveGPS layer", null);
        if (collection.isEmpty()) {
            collection.add(new ArrayList());
        }
        for (Collection<RawGpsLayer.GpsPoint> collection2 : collection) {
            this.trackBeingWritten = collection2;
        }
        this.lbl = new JLabel();
    }

    void setCurrentPosition(double d, double d2) {
        LatLon latLon = new LatLon(d, d2);
        if (this.lastPos != null && latLon.equalsEpsilon(this.lastPos)) {
            return;
        }
        this.lastPos = latLon;
        this.lastPoint = new RawGpsLayer.GpsPoint(latLon, new Date().toString());
        this.trackBeingWritten.add(this.lastPoint);
        if (this.autocenter) {
            this.center();
        }
        Main.map.repaint();
    }

    public void center() {
        if (this.lastPoint != null) {
            Main.map.mapView.zoomTo(this.lastPoint.eastNorth, Main.map.mapView.getScale());
        }
    }

    void setStatus(String string) {
        this.status = string;
        Main.map.repaint();
    }

    void setSpeed(float f) {
        this.speed = f;
        Main.map.repaint();
    }

    void setCourse(float f) {
        this.course = f;
        Main.map.repaint();
    }

    void setAutoCenter(boolean bl) {
        this.autocenter = bl;
    }

    public void paint(Graphics graphics, MapView mapView) {
        Object object;
        super.paint(graphics, mapView);
        int n = 50;
        Rectangle rectangle = mapView.getBounds();
        rectangle.y = rectangle.y + rectangle.height - n;
        rectangle.height = n;
        graphics.setColor(new Color(1.0f, 1.0f, 1.0f, 0.8f));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.lastPoint != null) {
            object = mapView.getPoint(this.lastPoint.eastNorth);
            graphics.setColor(Color.RED);
            graphics.drawOval(((Point)object).x - 10, ((Point)object).y - 10, 20, 20);
            graphics.drawOval(((Point)object).x - 9, ((Point)object).y - 9, 18, 18);
        }
        this.lbl.setText("gpsd: " + this.status + " Speed: " + this.speed + " Course: " + this.course);
        this.lbl.setBounds(0, 0, rectangle.width - 10, rectangle.height - 10);
        object = graphics.create(rectangle.x + 5, rectangle.y + 5, rectangle.width - 10, rectangle.height - 10);
        this.lbl.paint((Graphics)object);
    }
}

