/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.xml;

import com.kitfox.svg.xml.Base64Util;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    int buf;
    int numBytes;
    int numChunks;

    public Base64OutputStream(OutputStream out) {
        super(out);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        switch (this.numBytes) {
            case 1: {
                this.buf <<= 4;
                this.out.write(this.getBase64Byte(1));
                this.out.write(this.getBase64Byte(0));
                this.out.write(61);
                this.out.write(61);
                break;
            }
            case 2: {
                this.buf <<= 2;
                this.out.write(this.getBase64Byte(2));
                this.out.write(this.getBase64Byte(1));
                this.out.write(this.getBase64Byte(0));
                this.out.write(61);
                break;
            }
            case 3: {
                this.out.write(this.getBase64Byte(3));
                this.out.write(this.getBase64Byte(2));
                this.out.write(this.getBase64Byte(1));
                this.out.write(this.getBase64Byte(0));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.out.close();
    }

    public void write(int b) throws IOException {
        this.buf = this.buf << 8 | 0xFF & b;
        ++this.numBytes;
        if (this.numBytes == 3) {
            this.out.write(this.getBase64Byte(3));
            this.out.write(this.getBase64Byte(2));
            this.out.write(this.getBase64Byte(1));
            this.out.write(this.getBase64Byte(0));
            this.numBytes = 0;
            ++this.numChunks;
            if (this.numChunks == 16) {
                this.numChunks = 0;
            }
        }
    }

    public byte getBase64Byte(int index) {
        return Base64Util.encodeByte(this.buf >> index * 6 & 0x3F);
    }
}

