/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import buildings_tools.MyDialog;
import java.awt.Choice;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import org.openstreetmap.josm.tools.I18n;

public class AddressDialog
extends MyDialog {
    private static String lhousenum;
    private static String lstreetname;
    private static boolean inc;
    private JTextField housenum = new JTextField();
    private JTextField streetname = new JTextField();
    private Choice cincdec = new Choice();

    public AddressDialog() {
        super(I18n.tr((String)"Building address"));
        this.addLabelled(I18n.tr((String)"House number:"), this.housenum);
        this.addLabelled(I18n.tr((String)"Street Name:"), this.streetname);
        this.housenum.setText(AddressDialog.nextHouseNum());
        this.streetname.setText(lstreetname);
        this.cincdec.add(I18n.tr((String)"Increment"));
        this.cincdec.add(I18n.tr((String)"Decrement"));
        this.cincdec.select(inc ? 0 : 1);
        this.addLabelled(I18n.tr((String)"Numbers:"), this.cincdec);
        this.setContent(this.panel);
        this.setupDialog();
    }

    private static String nextHouseNum() {
        if (lhousenum == null) {
            return "";
        }
        try {
            Integer num = NumberFormat.getInstance().parse(lhousenum).intValue();
            num = inc ? Integer.valueOf(num + 2) : Integer.valueOf(num - 2);
            return num.toString();
        }
        catch (ParseException e) {
            return lhousenum;
        }
    }

    public void saveValues() {
        lhousenum = this.housenum.getText();
        lstreetname = this.streetname.getText();
        inc = this.cincdec.getSelectedIndex() == 0;
    }

    public String getHouseNum() {
        return this.housenum.getText();
    }

    public String getStreetName() {
        return this.streetname.getText();
    }

    static {
        inc = true;
    }
}

