/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import buildings_tools.AdvancedSettingsDialog;
import buildings_tools.MyDialog;
import buildings_tools.ToolSettings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class BuildingSizeDialog
extends MyDialog {
    private JFormattedTextField twidth = new JFormattedTextField(NumberFormat.getInstance());
    private JFormattedTextField tlenstep = new JFormattedTextField(NumberFormat.getInstance());
    private JCheckBox caddr = new JCheckBox(I18n.tr((String)"Use Address dialog"));
    private JCheckBox cAutoSelect = new JCheckBox(I18n.tr((String)"Auto-select building"));

    public BuildingSizeDialog() {
        super(I18n.tr((String)"Set buildings size"));
        this.addLabelled(I18n.tr((String)"Buildings width:"), this.twidth);
        this.addLabelled(I18n.tr((String)"Length step:"), this.tlenstep);
        this.panel.add((Component)this.caddr, GBC.eol().fill(2));
        this.panel.add((Component)this.cAutoSelect, GBC.eol().fill(2));
        this.twidth.setValue(ToolSettings.getWidth());
        this.tlenstep.setValue(ToolSettings.getLenStep());
        this.caddr.setSelected(ToolSettings.isUsingAddr());
        this.cAutoSelect.setSelected(ToolSettings.isAutoSelect());
        JButton bAdv = new JButton(I18n.tr((String)"Advanced..."));
        bAdv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AdvancedSettingsDialog dlg = new AdvancedSettingsDialog();
                if (dlg.getValue() == 1) {
                    dlg.saveSettings();
                }
            }
        });
        this.panel.add((Component)bAdv, GBC.eol().insets(0, 5, 0, 0).anchor(13));
        this.setupDialog();
        this.showDialog();
    }

    public double width() {
        try {
            return NumberFormat.getInstance().parse(this.twidth.getText()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public double lenstep() {
        try {
            return NumberFormat.getInstance().parse(this.tlenstep.getText()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public boolean useAddr() {
        return this.caddr.isSelected();
    }

    public void saveSettings() {
        ToolSettings.setSizes(this.width(), this.lenstep());
        ToolSettings.setAddrDialog(this.useAddr());
        ToolSettings.setAutoSelect(this.cAutoSelect.isSelected());
    }
}

