/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.NavigationControler;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.I18n;

public class IntersectionMissingAsViaError
extends Issue {
    private Way from;
    private Way to;
    private Node interesect;

    public IntersectionMissingAsViaError(IssuesModel parent, Way from, Way to, Node intersect) {
        super(parent, Severity.ERROR);
        this.from = from;
        this.to = to;
        this.interesect = intersect;
        this.actions.add(new SetVia());
        this.actions.add(new FixInEditorAction());
    }

    @Override
    public String getText() {
        String msg = I18n.tr((String)"The <strong>from</strong>-way <span class=\"object-name\">{0}</span> and the <strong>to</strong>-way <span class=\"object-name\">{1}</span> interesect at node <span class=\"object-name\">{2}</span> but <span class=\"object-name\">{2}</span> isn''t a <strong>via</strong>-object.<br> It is recommended to set <span class=\"object-name\">{2}</span> as unique <strong>via</strong>-object.", (Object[])new Object[]{this.from.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.to.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.interesect.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
        return msg;
    }

    class FixInEditorAction
    extends AbstractAction {
        public FixInEditorAction() {
            this.putValue("Name", I18n.tr((String)"Fix in editor"));
            this.putValue("ShortDescription", I18n.tr((String)"Go to Basic Editor and manually fix the list of via-objects"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IntersectionMissingAsViaError.this.getIssuesModel().getNavigationControler().gotoBasicEditor(NavigationControler.BasicEditorFokusTargets.VIA);
        }
    }

    class SetVia
    extends AbstractAction {
        public SetVia() {
            this.putValue("Name", I18n.tr((String)"Set via-Object"));
            this.putValue("ShortDescription", I18n.tr((String)"Replaces the currently configured via-objects with the node at the intersection"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IntersectionMissingAsViaError.this.getIssuesModel().getEditorModel().setVias(Collections.singletonList(IntersectionMissingAsViaError.this.interesect));
        }
    }
}

