/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnrestrictions.TurnRestrictionBuilder;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditor;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorManager;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionSelectionPopupPanel;
import org.openstreetmap.josm.tools.I18n;

public class CreateOrEditTurnRestrictionAction
extends JosmAction {
    private static final Logger logger = Logger.getLogger(CreateOrEditTurnRestrictionAction.class.getName());
    private static CreateOrEditTurnRestrictionAction instance;

    public static void install() {
        String value = Main.pref.get("turnrestrictions.edit-shortcut", "shift ctrl T");
        KeyStroke key = KeyStroke.getKeyStroke(value);
        if (key == null) {
            System.out.println(I18n.tr((String)"Warning: illegal value ''{0}'' for preference key ''{1}''. Falling back to default value ''shift ctrl T''.", (Object[])new Object[]{value, "turnrestrictions.edit-shortcut"}));
            key = KeyStroke.getKeyStroke("shift ctrl T");
        }
        Main.registerActionShortcut((Action)((Object)CreateOrEditTurnRestrictionAction.getInstance()), (KeyStroke)key);
    }

    public static CreateOrEditTurnRestrictionAction getInstance() {
        if (instance == null) {
            instance = new CreateOrEditTurnRestrictionAction();
        }
        return instance;
    }

    protected CreateOrEditTurnRestrictionAction() {
        super(I18n.tr((String)"Create/Edit turn restriction..."), null, I18n.tr((String)"Create or edit a turn restriction."), null, false);
    }

    public void actionPerformed(ActionEvent e) {
        OsmDataLayer layer = Main.main.getEditLayer();
        if (layer == null) {
            return;
        }
        Collection<Relation> trs = TurnRestrictionSelectionPopupPanel.getTurnRestrictionsParticipatingIn(layer.data.getSelected());
        if (trs.isEmpty()) {
            Relation tr = new TurnRestrictionBuilder().buildFromSelection(layer);
            TurnRestrictionEditor editor = new TurnRestrictionEditor((Component)Main.map.mapView, layer, tr);
            TurnRestrictionEditorManager.getInstance().positionOnScreen(editor);
            TurnRestrictionEditorManager.getInstance().register(layer, tr, editor);
            editor.setVisible(true);
        } else {
            TurnRestrictionSelectionPopupPanel pnl = new TurnRestrictionSelectionPopupPanel(layer);
            pnl.launch();
        }
    }
}

