/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;

public class VanDerGrintenProjection
extends Projection {
    private static final double TOL = 1.0E-10;
    private static final double THIRD = 0.3333333333333333;
    private static final double TWO_THRD = 0.6666666666666666;
    private static final double C2_27 = 0.07407407407407407;
    private static final double PI4_3 = 4.188790204786391;
    private static final double PISQ = Math.PI * Math.PI;
    private static final double TPISQ = 19.739208802178716;
    private static final double HPISQ = 4.934802200544679;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.abs(d2 / 1.5707963267948966);
        if (d3 - 1.0E-10 > 1.0) {
            throw new ProjectionException("F");
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (Math.abs(d2) <= 1.0E-10) {
            projCoordinate.x = d;
            projCoordinate.y = 0.0;
        } else if (Math.abs(d) <= 1.0E-10 || Math.abs(d3 - 1.0) < 1.0E-10) {
            projCoordinate.x = 0.0;
            projCoordinate.y = Math.PI * Math.tan(0.5 * Math.asin(d3));
            if (d2 < 0.0) {
                projCoordinate.y = -projCoordinate.y;
            }
        } else {
            double d4 = 0.5 * Math.abs(Math.PI / d - d / Math.PI);
            double d5 = d4 * d4;
            double d6 = Math.sqrt(1.0 - d3 * d3);
            d6 /= d3 + d6 - 1.0;
            double d7 = d6 * d6;
            d3 = d6 * (2.0 / d3 - 1.0);
            d3 *= d3;
            projCoordinate.x = d6 - d3;
            d6 = d3 + d5;
            projCoordinate.x = Math.PI * (d4 * projCoordinate.x + Math.sqrt(d5 * projCoordinate.x * projCoordinate.x - d6 * (d7 - d3))) / d6;
            if (d < 0.0) {
                projCoordinate.x = -projCoordinate.x;
            }
            projCoordinate.y = Math.abs(projCoordinate.x / Math.PI);
            projCoordinate.y = 1.0 - projCoordinate.y * (projCoordinate.y + 2.0 * d4);
            if (projCoordinate.y < -1.0E-10) {
                throw new ProjectionException("F");
            }
            projCoordinate.y = projCoordinate.y < 0.0 ? 0.0 : Math.sqrt(projCoordinate.y) * (d2 < 0.0 ? -Math.PI : Math.PI);
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        double d4;
        double d5 = d * d;
        double d6 = Math.abs(d2);
        if (d4 < 1.0E-10) {
            projCoordinate.y = 0.0;
            double d7 = d5 * d5 + 19.739208802178716 * (d5 + 4.934802200544679);
            projCoordinate.x = Math.abs(d) <= 1.0E-10 ? 0.0 : 0.5 * (d5 - Math.PI * Math.PI + Math.sqrt(d7)) / d;
            return projCoordinate;
        }
        double d8 = d2 * d2;
        double d9 = d5 + d8;
        double d10 = d9 * d9;
        double d11 = -Math.PI * d6 * (d9 + Math.PI * Math.PI);
        double d12 = d10 + Math.PI * 2 * (d6 * d9 + Math.PI * (d8 + Math.PI * (d6 + 1.5707963267948966)));
        double d13 = d11 + Math.PI * Math.PI * (d9 - 3.0 * d8);
        double d14 = Math.PI * d6;
        double d15 = d11 / d12 - 0.3333333333333333 * (d13 /= d12) * d13;
        double d16 = 2.0 * Math.sqrt(-0.3333333333333333 * d15);
        double d17 = 0.07407407407407407 * d13 * d13 * d13 + (d14 * d14 - 0.3333333333333333 * d13 * d11) / d12;
        d17 = 3.0 * d17 / (d15 * d16);
        double d18 = Math.abs(d17);
        if (d3 - 1.0E-10 <= 1.0) {
            d17 = d18 > 1.0 ? (d17 > 0.0 ? 0.0 : Math.PI) : Math.acos(d17);
            projCoordinate.y = Math.PI * (d16 * Math.cos(d17 * 0.3333333333333333 + 4.188790204786391) - 0.3333333333333333 * d13);
            if (d2 < 0.0) {
                projCoordinate.y = -projCoordinate.y;
            }
        } else {
            throw new ProjectionException("I");
        }
        d18 = d10 + 19.739208802178716 * (d5 - d8 + 4.934802200544679);
        projCoordinate.x = Math.abs(d) <= 1.0E-10 ? 0.0 : 0.5 * (d9 - Math.PI * Math.PI + (d18 <= 0.0 ? 0.0 : Math.sqrt(d18))) / d;
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "van der Grinten (I)";
    }
}

