/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class BipolarProjection
extends Projection {
    private boolean noskew;
    private static final double EPS = 1.0E-10;
    private static final double EPS10 = 1.0E-10;
    private static final double ONEEPS = 1.000000001;
    private static final int NITER = 10;
    private static final double lamB = -0.3489497672625068;
    private static final double n = 0.6305584488127469;
    private static final double F = 1.8972474256746104;
    private static final double Azab = 0.8165004367468637;
    private static final double Azba = 1.8226184385618593;
    private static final double T = 1.27246578267089;
    private static final double rhoc = 1.2070912152156872;
    private static final double cAzc = 0.6969152303867837;
    private static final double sAzc = 0.7171535133114361;
    private static final double C45 = 0.7071067811865476;
    private static final double S45 = 0.7071067811865476;
    private static final double C20 = 0.9396926207859084;
    private static final double S20 = -0.3420201433256687;
    private static final double R110 = 1.9198621771937625;
    private static final double R104 = 1.8151424220741028;

    public BipolarProjection() {
        this.minLatitude = Math.toRadians(-80.0);
        this.maxLatitude = Math.toRadians(80.0);
        this.projectionLongitude = Math.toRadians(-90.0);
        this.minLongitude = Math.toRadians(-90.0);
        this.maxLongitude = Math.toRadians(90.0);
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        double d4;
        double d5;
        double d6;
        boolean bl;
        double d7;
        double d8;
        double d9 = Math.cos(d2);
        double d10 = Math.sin(d2);
        double d11 = -0.3489497672625068 - d;
        double d12 = Math.cos(d11);
        d11 = Math.sin(d11);
        if (Math.abs(Math.abs(d2) - 1.5707963267948966) < 1.0E-10) {
            d8 = d2 < 0.0 ? Math.PI : 0.0;
            d7 = Double.MAX_VALUE;
        } else {
            d7 = d10 / d9;
            d8 = Math.atan2(d11, 0.7071067811865476 * (d7 - d12));
        }
        if (bl = d8 > 1.8226184385618593) {
            d11 = d + 1.9198621771937625;
            d12 = Math.cos(d11);
            d11 = Math.sin(d11);
            d6 = -0.3420201433256687 * d10 + 0.9396926207859084 * d9 * d12;
            if (Math.abs(d6) > 1.0) {
                if (Math.abs(d6) > 1.000000001) {
                    throw new ProjectionException("F");
                }
                d6 = d6 < 0.0 ? -1.0 : 1.0;
            } else {
                d6 = Math.acos(d6);
            }
            if (d7 != Double.MAX_VALUE) {
                d8 = Math.atan2(d11, 0.9396926207859084 * d7 - -0.3420201433256687 * d12);
            }
            d5 = 0.8165004367468637;
            projCoordinate.y = 1.2070912152156872;
        } else {
            d6 = 0.7071067811865476 * (d10 + d9 * d12);
            if (Math.abs(d6) > 1.0) {
                if (Math.abs(d6) > 1.000000001) {
                    throw new ProjectionException("F");
                }
                d6 = d6 < 0.0 ? -1.0 : 1.0;
            } else {
                d6 = Math.acos(d6);
            }
            d5 = 1.8226184385618593;
            projCoordinate.y = -1.2070912152156872;
        }
        if (d6 < 0.0) {
            throw new ProjectionException("F");
        }
        double d13 = Math.pow(Math.tan(0.5 * d6), 0.6305584488127469);
        double d14 = 1.8972474256746104 * d13;
        double d15 = 0.5 * (1.8151424220741028 - d6);
        if (d4 < 0.0) {
            throw new ProjectionException("F");
        }
        if (Math.abs(d15 = (d13 + Math.pow(d15, 0.6305584488127469)) / 1.27246578267089) > 1.0) {
            if (Math.abs(d15) > 1.000000001) {
                throw new ProjectionException("F");
            }
            d15 = d15 < 0.0 ? -1.0 : 1.0;
        } else {
            d15 = Math.acos(d15);
        }
        d13 = 0.6305584488127469 * (d5 - d8);
        if (Math.abs(d3) < d15) {
            d14 /= Math.cos(d15 + (bl ? d13 : -d13));
        }
        projCoordinate.x = d14 * Math.sin(d13);
        projCoordinate.y = projCoordinate.y + (bl ? -d14 : d14) * Math.cos(d13);
        if (this.noskew) {
            d13 = projCoordinate.x;
            projCoordinate.x = -projCoordinate.x * 0.6969152303867837 - projCoordinate.y * 0.7171535133114361;
            projCoordinate.y = -projCoordinate.y * 0.6969152303867837 + d13 * 0.7171535133114361;
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        int n;
        double d3;
        double d4;
        double d5;
        double d6;
        boolean bl;
        double d7 = 0.0;
        if (this.noskew) {
            double d8 = d;
            projCoordinate.x = -d * 0.6969152303867837 + d2 * 0.7171535133114361;
            projCoordinate.y = -d2 * 0.6969152303867837 - d8 * 0.7171535133114361;
        }
        if (bl = d < 0.0) {
            projCoordinate.y = 1.2070912152156872 - d2;
            d6 = -0.3420201433256687;
            d5 = 0.9396926207859084;
            d4 = 0.8165004367468637;
        } else {
            projCoordinate.y += 1.2070912152156872;
            d6 = 0.7071067811865476;
            d5 = 0.7071067811865476;
            d4 = 1.8226184385618593;
        }
        double d9 = d3 = ProjectionMath.distance(d, d2);
        double d10 = d3;
        double d11 = Math.atan2(d, d2);
        double d12 = Math.abs(d11);
        for (n = 10; n > 0; --n) {
            d7 = 2.0 * Math.atan(Math.pow(d3 / 1.8972474256746104, 1.585895806935677));
            double d13 = Math.acos((Math.pow(Math.tan(0.5 * d7), 0.6305584488127469) + Math.pow(Math.tan(0.5 * (1.8151424220741028 - d7)), 0.6305584488127469)) / 1.27246578267089);
            if (d12 < d13) {
                d3 = d9 * Math.cos(d13 + (bl ? d11 : -d11));
            }
            if (Math.abs(d10 - d3) < 1.0E-10) break;
            d10 = d3;
        }
        if (n == 0) {
            throw new ProjectionException("I");
        }
        d11 = d4 - d11 / 0.6305584488127469;
        projCoordinate.y = Math.asin(d6 * Math.cos(d7) + d5 * Math.sin(d7) * Math.cos(d11));
        projCoordinate.x = Math.atan2(Math.sin(d11), d5 / Math.tan(d7) - d6 * Math.cos(d11));
        projCoordinate.x = bl ? (projCoordinate.x -= 1.9198621771937625) : -0.3489497672625068 - projCoordinate.x;
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public String toString() {
        return "Bipolar Conic of Western Hemisphere";
    }
}

