/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.util;

import java.awt.geom.Rectangle2D;
import org.osgeo.proj4j.ConvergenceFailureException;
import org.osgeo.proj4j.InvalidValueException;

public class ProjectionMath {
    public static final double PI = Math.PI;
    public static final double HALFPI = 1.5707963267948966;
    public static final double QUARTERPI = 0.7853981633974483;
    public static final double TWOPI = Math.PI * 2;
    public static final double RTD = 57.29577951308232;
    public static final double DTR = Math.PI / 180;
    public static final Rectangle2D WORLD_BOUNDS_RAD = new Rectangle2D.Double(-Math.PI, -1.5707963267948966, Math.PI * 2, Math.PI);
    public static final Rectangle2D WORLD_BOUNDS = new Rectangle2D.Double(-180.0, -90.0, 360.0, 180.0);
    private static final int N_ITER = 15;
    private static final double C00 = 1.0;
    private static final double C02 = 0.25;
    private static final double C04 = 0.046875;
    private static final double C06 = 0.01953125;
    private static final double C08 = 0.01068115234375;
    private static final double C22 = 0.75;
    private static final double C44 = 0.46875;
    private static final double C46 = 0.013020833333333334;
    private static final double C48 = 0.007120768229166667;
    private static final double C66 = 0.3645833333333333;
    private static final double C68 = 0.005696614583333333;
    private static final double C88 = 0.3076171875;
    private static final int MAX_ITER = 10;
    private static final double P00 = 0.3333333333333333;
    private static final double P01 = 0.17222222222222222;
    private static final double P02 = 0.10257936507936508;
    private static final double P10 = 0.06388888888888888;
    private static final double P11 = 0.0664021164021164;
    private static final double P20 = 0.016415012942191543;

    public static double sind(double d) {
        return Math.sin(d * (Math.PI / 180));
    }

    public static double cosd(double d) {
        return Math.cos(d * (Math.PI / 180));
    }

    public static double tand(double d) {
        return Math.tan(d * (Math.PI / 180));
    }

    public static double asind(double d) {
        return Math.asin(d) * 57.29577951308232;
    }

    public static double acosd(double d) {
        return Math.acos(d) * 57.29577951308232;
    }

    public static double atand(double d) {
        return Math.atan(d) * 57.29577951308232;
    }

    public static double atan2d(double d, double d2) {
        return Math.atan2(d, d2) * 57.29577951308232;
    }

    public static double asin(double d) {
        if (Math.abs(d) > 1.0) {
            return d < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        return Math.asin(d);
    }

    public static double acos(double d) {
        if (Math.abs(d) > 1.0) {
            return d < 0.0 ? Math.PI : 0.0;
        }
        return Math.acos(d);
    }

    public static double sqrt(double d) {
        return d < 0.0 ? 0.0 : Math.sqrt(d);
    }

    public static double distance(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    public static double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        } else if (d == 0.0) {
            return d2 < 0.0 ? -d2 : d2;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        } else if (d2 == 0.0) {
            return d;
        }
        if (d < d2) {
            return d2 * Math.sqrt(1.0 + (d /= d2) * d);
        }
        return d * Math.sqrt(1.0 + (d2 /= d) * d2);
    }

    public static double atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    public static double trunc(double d) {
        return d < 0.0 ? Math.ceil(d) : Math.floor(d);
    }

    public static double frac(double d) {
        return d - ProjectionMath.trunc(d);
    }

    public static double degToRad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double radToDeg(double d) {
        return d * 180.0 / Math.PI;
    }

    public static double dmsToRad(double d, double d2, double d3) {
        if (d >= 0.0) {
            return (d + d2 / 60.0 + d3 / 3600.0) * Math.PI / 180.0;
        }
        return (d - d2 / 60.0 - d3 / 3600.0) * Math.PI / 180.0;
    }

    public static double dmsToDeg(double d, double d2, double d3) {
        if (d >= 0.0) {
            return d + d2 / 60.0 + d3 / 3600.0;
        }
        return d - d2 / 60.0 - d3 / 3600.0;
    }

    public static double normalizeLatitude(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new InvalidValueException("Infinite latitude");
        }
        while (d > 1.5707963267948966) {
            d -= Math.PI;
        }
        while (d < -1.5707963267948966) {
            d += Math.PI;
        }
        return d;
    }

    public static double normalizeLongitude(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new InvalidValueException("Infinite longitude");
        }
        while (d > Math.PI) {
            d -= Math.PI * 2;
        }
        while (d < -Math.PI) {
            d += Math.PI * 2;
        }
        return d;
    }

    public static double normalizeAngle(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new InvalidValueException("Infinite angle");
        }
        while (d > Math.PI * 2) {
            d -= Math.PI * 2;
        }
        while (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    public static double greatCircleDistance(double d, double d2, double d3, double d4) {
        double d5 = Math.sin((d4 - d2) / 2.0);
        double d6 = Math.sin((d3 - d) / 2.0);
        double d7 = Math.sqrt(d5 * d5 + Math.cos(d2) * Math.cos(d4) * d6 * d6);
        return 2.0 * Math.asin(d7);
    }

    public static double sphericalAzimuth(double d, double d2, double d3, double d4) {
        double d5 = d4 - d2;
        double d6 = Math.cos(d3);
        return Math.atan2(d6 * Math.sin(d5), Math.cos(d) * Math.sin(d3) - Math.sin(d) * d6 * Math.cos(d5));
    }

    public static boolean sameSigns(double d, double d2) {
        return d < 0.0 == d2 < 0.0;
    }

    public static boolean sameSigns(int n, int n2) {
        return n < 0 == n2 < 0;
    }

    public static double takeSign(double d, double d2) {
        d = Math.abs(d);
        if (d2 < 0.0) {
            return -d;
        }
        return d;
    }

    public static int takeSign(int n, int n2) {
        n = Math.abs(n);
        if (n2 < 0) {
            return -n;
        }
        return n;
    }

    public static double cross(double d, double d2, double d3, double d4) {
        return d * d4 - d3 * d2;
    }

    public static double longitudeDistance(double d, double d2) {
        return Math.min(Math.abs(d - d2), (d < 0.0 ? d + Math.PI : Math.PI - d) + (d2 < 0.0 ? d2 + Math.PI : Math.PI - d2));
    }

    public static double geocentricLatitude(double d, double d2) {
        double d3 = 1.0 - d2;
        return Math.atan(d3 * d3 * Math.tan(d));
    }

    public static double geographicLatitude(double d, double d2) {
        double d3 = 1.0 - d2;
        return Math.atan(Math.tan(d) / (d3 * d3));
    }

    public static double tsfn(double d, double d2, double d3) {
        return Math.tan(0.5 * (1.5707963267948966 - d)) / Math.pow((1.0 - (d2 *= d3)) / (1.0 + d2), 0.5 * d3);
    }

    public static double msfn(double d, double d2, double d3) {
        return d2 / Math.sqrt(1.0 - d3 * d * d);
    }

    public static double phi2(double d, double d2) {
        double d3;
        double d4 = 0.5 * d2;
        double d5 = 1.5707963267948966 - 2.0 * Math.atan(d);
        int n = 15;
        do {
            double d6 = d2 * Math.sin(d5);
            d3 = 1.5707963267948966 - 2.0 * Math.atan(d * Math.pow((1.0 - d6) / (1.0 + d6), d4)) - d5;
            d5 += d3;
        } while (Math.abs(d3) > 1.0E-10 && --n != 0);
        if (n <= 0) {
            throw new ConvergenceFailureException("Computation of phi2 failed to converage after 15 iterations");
        }
        return d5;
    }

    public static double[] enfn(double d) {
        double[] dArray = new double[5];
        dArray[0] = 1.0 - d * (0.25 + d * (0.046875 + d * (0.01953125 + d * 0.01068115234375)));
        dArray[1] = d * (0.75 - d * (0.046875 + d * (0.01953125 + d * 0.01068115234375)));
        double d2 = d * d;
        dArray[2] = d2 * (0.46875 - d * (0.013020833333333334 + d * 0.007120768229166667));
        dArray[3] = (d2 *= d) * (0.3645833333333333 - d * 0.005696614583333333);
        dArray[4] = d2 * d * 0.3076171875;
        return dArray;
    }

    public static double mlfn(double d, double d2, double d3, double[] dArray) {
        d3 *= d2;
        d2 *= d2;
        return dArray[0] * d - d3 * (dArray[1] + d2 * (dArray[2] + d2 * (dArray[3] + d2 * dArray[4])));
    }

    public static double inv_mlfn(double d, double d2, double[] dArray) {
        double d3 = 1.0 / (1.0 - d2);
        double d4 = d;
        for (int i = 10; i != 0; --i) {
            double d5 = Math.sin(d4);
            double d6 = 1.0 - d2 * d5 * d5;
            d6 = (ProjectionMath.mlfn(d4, d5, Math.cos(d4), dArray) - d) * (d6 * Math.sqrt(d6)) * d3;
            d4 -= d6;
            if (!(Math.abs(d6) < 1.0E-11)) continue;
            return d4;
        }
        return d4;
    }

    public static double[] authset(double d) {
        double[] dArray = new double[3];
        dArray[0] = d * 0.3333333333333333;
        double d2 = d * d;
        dArray[0] = dArray[0] + d2 * 0.17222222222222222;
        dArray[1] = d2 * 0.06388888888888888;
        dArray[0] = dArray[0] + (d2 *= d) * 0.10257936507936508;
        dArray[1] = dArray[1] + d2 * 0.0664021164021164;
        dArray[2] = d2 * 0.016415012942191543;
        return dArray;
    }

    public static double authlat(double d, double[] dArray) {
        double d2 = d + d;
        return d + dArray[0] * Math.sin(d2) + dArray[1] * Math.sin(d2 + d2) + dArray[2] * Math.sin(d2 + d2 + d2);
    }

    public static double qsfn(double d, double d2, double d3) {
        if (d2 >= 1.0E-7) {
            double d4 = d2 * d;
            return d3 * (d / (1.0 - d4 * d4) - 0.5 / d2 * Math.log((1.0 - d4) / (1.0 + d4)));
        }
        return d + d;
    }

    public static double niceNumber(double d, boolean bl) {
        int n = (int)Math.floor(Math.log(d) / Math.log(10.0));
        double d2 = d / Math.pow(10.0, n);
        double d3 = bl ? (d2 < 1.5 ? 1.0 : (d2 < 3.0 ? 2.0 : (d2 < 7.0 ? 5.0 : 10.0))) : (d2 <= 1.0 ? 1.0 : (d2 <= 2.0 ? 2.0 : (d2 <= 5.0 ? 5.0 : 10.0)));
        return d3 * Math.pow(10.0, n);
    }
}

