/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.units;

import java.text.ParseException;
import org.osgeo.proj4j.units.AngleFormat;
import org.osgeo.proj4j.units.Unit;

public class DegreeUnit
extends Unit {
    static final long serialVersionUID = -3212757578604686538L;
    private static AngleFormat format = new AngleFormat("DdM", true);

    public DegreeUnit() {
        super("degree", "degrees", "deg", 1.0);
    }

    @Override
    public double parse(String string) throws NumberFormatException {
        try {
            return format.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(parseException.getMessage());
        }
    }

    @Override
    public String format(double d) {
        return format.format(d) + " " + this.abbreviation;
    }

    @Override
    public String format(double d, boolean bl) {
        if (bl) {
            return format.format(d) + " " + this.abbreviation;
        }
        return format.format(d);
    }

    @Override
    public String format(double d, double d2, boolean bl) {
        if (bl) {
            return format.format(d) + "/" + format.format(d2) + " " + this.abbreviation;
        }
        return format.format(d) + "/" + format.format(d2);
    }
}

