/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;

public class NicolosiProjection
extends Projection {
    private static final double EPS = 1.0E-10;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (Math.abs(d) < 1.0E-10) {
            projCoordinate.x = 0.0;
            projCoordinate.y = d2;
        } else if (Math.abs(d2) < 1.0E-10) {
            projCoordinate.x = d;
            projCoordinate.y = 0.0;
        } else if (Math.abs(Math.abs(d) - 1.5707963267948966) < 1.0E-10) {
            projCoordinate.x = d * Math.cos(d2);
            projCoordinate.y = 1.5707963267948966 * Math.sin(d2);
        } else if (Math.abs(Math.abs(d2) - 1.5707963267948966) < 1.0E-10) {
            projCoordinate.x = 0.0;
            projCoordinate.y = d2;
        } else {
            double d3 = 1.5707963267948966 / d - d / 1.5707963267948966;
            double d4 = d2 / 1.5707963267948966;
            double d5 = Math.sin(d2);
            double d6 = (1.0 - d4 * d4) / (d5 - d4);
            double d7 = d3 / d6;
            d7 *= d7;
            double d8 = (d3 * d5 / d6 - 0.5 * d3) / (1.0 + d7);
            double d9 = (d5 / d7 + 0.5 * d6) / (1.0 + 1.0 / d7);
            double d10 = Math.cos(d2);
            d10 = Math.sqrt(d8 * d8 + d10 * d10 / (1.0 + d7));
            projCoordinate.x = 1.5707963267948966 * (d8 + (d < 0.0 ? -d10 : d10));
            double d11 = Math.sqrt(d9 * d9 - (d5 * d5 / d7 + d6 * d5 - 1.0) / (1.0 + 1.0 / d7));
            projCoordinate.y = 1.5707963267948966 * (d9 + (d2 < 0.0 ? d11 : -d11));
        }
        return projCoordinate;
    }

    @Override
    public String toString() {
        return "Nicolosi Globular";
    }
}

