/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.PseudoCylindricalProjection;

public class LoximuthalProjection
extends PseudoCylindricalProjection {
    private static final double FC = 0.9213177319235613;
    private static final double RP = 0.3183098861837907;
    private static final double EPS = 1.0E-8;
    private double phi1 = Math.toRadians(40.0);
    private double cosphi1 = Math.cos(this.phi1);
    private double tanphi1 = Math.tan(0.7853981633974483 + 0.5 * this.phi1);

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        double d4 = d2 - this.phi1;
        d3 = d4 < 1.0E-8 ? d * this.cosphi1 : (Math.abs(d3 = 0.7853981633974483 + 0.5 * d2) < 1.0E-8 || Math.abs(Math.abs(d3) - 1.5707963267948966) < 1.0E-8 ? 0.0 : d * d4 / Math.log(Math.tan(d3) / this.tanphi1));
        projCoordinate.x = d3;
        projCoordinate.y = d4;
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        double d4 = d2 + this.phi1;
        d3 = Math.abs(d2) < 1.0E-8 ? d / this.cosphi1 : (Math.abs(d3 = 0.7853981633974483 + 0.5 * d2) < 1.0E-8 || Math.abs(Math.abs(d) - 1.5707963267948966) < 1.0E-8 ? 0.0 : d * Math.log(Math.tan(d3) / this.tanphi1) / d2);
        projCoordinate.x = d3;
        projCoordinate.y = d4;
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Loximuthal";
    }
}

