/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;

public class FaheyProjection
extends Projection {
    private static final double TOL = 1.0E-6;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = Math.tan(0.5 * d2);
        projCoordinate.y = 1.819152 * projCoordinate.x;
        projCoordinate.x = 0.819152 * d * this.asqrt(1.0 - projCoordinate.x * projCoordinate.x);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        projCoordinate.y = 2.0 * Math.atan(projCoordinate.y /= 1.819152);
        projCoordinate.y = 1.0 - d2 * d2;
        projCoordinate.x = Math.abs(d3) < 1.0E-6 ? 0.0 : d / (0.819152 * Math.sqrt(d2));
        return projCoordinate;
    }

    private double asqrt(double d) {
        return d <= 0.0 ? 0.0 : Math.sqrt(d);
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Fahey";
    }
}

