/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class BonneProjection
extends Projection {
    private double phi1;
    private double cphi1;
    private double am1;
    private double m1;
    private double[] en;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            double d3 = this.cphi1 + this.phi1 - d2;
            if (Math.abs(d3) > 1.0E-10) {
                double d4 = d * Math.cos(d2) / d3;
                projCoordinate.x = d3 * Math.sin(d4);
                projCoordinate.y = this.cphi1 - d3 * Math.cos(d4);
            } else {
                projCoordinate.y = 0.0;
                projCoordinate.x = 0.0;
            }
        } else {
            double d5 = Math.sin(d2);
            double d6 = Math.cos(d2);
            double d7 = this.am1 + this.m1 - ProjectionMath.mlfn(d2, d5, d6, this.en);
            d5 = d6 * d / (d7 * Math.sqrt(1.0 - this.es * d5 * d5));
            projCoordinate.x = d7 * Math.sin(d5);
            projCoordinate.y = this.am1 - d7 * Math.cos(d5);
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            projCoordinate.y = this.cphi1 - d2;
            double d3 = ProjectionMath.distance(d, projCoordinate.y);
            projCoordinate.y = this.cphi1 + this.phi1 - d3;
            if (Math.abs(projCoordinate.y) > 1.5707963267948966) {
                throw new ProjectionException("I");
            }
            projCoordinate.x = Math.abs(Math.abs(projCoordinate.y) - 1.5707963267948966) <= 1.0E-10 ? 0.0 : d3 * Math.atan2(d, d2) / Math.cos(projCoordinate.y);
        } else {
            double d4;
            projCoordinate.y = this.am1 - d2;
            double d5 = ProjectionMath.distance(d, projCoordinate.y);
            projCoordinate.y = ProjectionMath.inv_mlfn(this.am1 + this.m1 - d5, this.es, this.en);
            double d6 = Math.abs(projCoordinate.y);
            if (d4 < 1.5707963267948966) {
                d6 = Math.sin(projCoordinate.y);
                projCoordinate.x = d5 * Math.atan2(d, d2) * Math.sqrt(1.0 - this.es * d6 * d6) / Math.cos(projCoordinate.y);
            } else if (Math.abs(d6 - 1.5707963267948966) <= 1.0E-10) {
                projCoordinate.x = 0.0;
            } else {
                throw new ProjectionException("I");
            }
        }
        return projCoordinate;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.phi1 = 1.5707963267948966;
        if (Math.abs(this.phi1) < 1.0E-10) {
            throw new ProjectionException("-23");
        }
        if (!this.spherical) {
            this.en = ProjectionMath.enfn(this.es);
            this.am1 = Math.sin(this.phi1);
            double d = Math.cos(this.phi1);
            this.m1 = ProjectionMath.mlfn(this.phi1, this.am1, d, this.en);
            this.am1 = d / (Math.sqrt(1.0 - this.es * this.am1 * this.am1) * this.am1);
        } else {
            this.cphi1 = Math.abs(this.phi1) + 1.0E-10 >= 1.5707963267948966 ? 0.0 : 1.0 / Math.tan(this.phi1);
        }
    }

    @Override
    public String toString() {
        return "Bonne";
    }
}

