/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class AlbersProjection
extends Projection {
    private static final double EPS10 = 1.0E-10;
    private static final double TOL7 = 1.0E-7;
    private double ec;
    private double n;
    private double c;
    private double dd;
    private double n2;
    private double rho0;
    private double phi1;
    private double phi2;
    private double[] en;
    private static final int N_ITER = 15;
    private static final double EPSILON = 1.0E-7;
    private static final double TOL = 1.0E-10;

    public AlbersProjection() {
        this.minLatitude = Math.toRadians(0.0);
        this.maxLatitude = Math.toRadians(80.0);
        this.projectionLatitude1 = ProjectionMath.degToRad(45.5);
        this.projectionLatitude2 = ProjectionMath.degToRad(29.5);
        this.initialize();
    }

    private static double phi1_(double d, double d2, double d3) {
        double d4;
        double d5 = Math.asin(0.5 * d);
        if (d2 < 1.0E-7) {
            return d5;
        }
        int n = 15;
        do {
            double d6 = Math.sin(d5);
            double d7 = Math.cos(d5);
            double d8 = d2 * d6;
            double d9 = 1.0 - d8 * d8;
            d4 = 0.5 * d9 * d9 / d7 * (d / d3 - d6 / d9 + 0.5 / d2 * Math.log((1.0 - d8) / (1.0 + d8)));
            d5 += d4;
        } while (Math.abs(d4) > 1.0E-10 && --n != 0);
        return n != 0 ? d5 : Double.MAX_VALUE;
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        double d4 = this.c - (!this.spherical ? this.n * ProjectionMath.qsfn(Math.sin(d2), this.e, this.one_es) : this.n2 * Math.sin(d2));
        if (d3 < 0.0) {
            throw new ProjectionException("F");
        }
        d4 = this.dd * Math.sqrt(d4);
        projCoordinate.x = d4 * Math.sin(d *= this.n);
        projCoordinate.y = this.rho0 - d4 * Math.cos(d);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = ProjectionMath.distance(d, d2 = this.rho0 - d2);
        if (d3 != 0.0) {
            double d4;
            if (this.n < 0.0) {
                d3 = -d3;
                d = -d;
                d2 = -d2;
            }
            double d5 = d3 / this.dd;
            if (!this.spherical) {
                if (Math.abs(this.ec - Math.abs(d5 = (this.c - d5 * d5) / this.n)) > 1.0E-7) {
                    if ((d5 = AlbersProjection.phi1_(d5, this.e, this.one_es)) == Double.MAX_VALUE) {
                        throw new ProjectionException("I");
                    }
                } else {
                    d5 = d5 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
                }
            } else {
                double d6;
                projCoordinate.y = (this.c - d5 * d5) / this.n2;
                d5 = Math.abs(d6) <= 1.0 ? Math.asin(d5) : (d5 < 0.0 ? -1.5707963267948966 : 1.5707963267948966);
            }
            projCoordinate.x = d4 = Math.atan2(d, d2) / this.n;
            projCoordinate.y = d5;
        } else {
            projCoordinate.x = 0.0;
            projCoordinate.y = this.n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return projCoordinate;
    }

    @Override
    public void initialize() {
        boolean bl;
        double d;
        super.initialize();
        this.phi1 = this.projectionLatitude1;
        this.phi2 = this.projectionLatitude2;
        if (Math.abs(this.phi1 + this.phi2) < 1.0E-10) {
            throw new ProjectionException("-21");
        }
        this.n = d = Math.sin(this.phi1);
        double d2 = Math.cos(this.phi1);
        boolean bl2 = bl = Math.abs(this.phi1 - this.phi2) >= 1.0E-10;
        if (!this.spherical) {
            this.en = ProjectionMath.enfn(this.es);
            if (this.en == null) {
                throw new ProjectionException("0");
            }
            double d3 = ProjectionMath.msfn(d, d2, this.es);
            double d4 = ProjectionMath.qsfn(d, this.e, this.one_es);
            if (bl) {
                d = Math.sin(this.phi2);
                d2 = Math.cos(this.phi2);
                double d5 = ProjectionMath.msfn(d, d2, this.es);
                double d6 = ProjectionMath.qsfn(d, this.e, this.one_es);
                this.n = (d3 * d3 - d5 * d5) / (d6 - d4);
            }
            this.ec = 1.0 - 0.5 * this.one_es * Math.log((1.0 - this.e) / (1.0 + this.e)) / this.e;
            this.c = d3 * d3 + this.n * d4;
            this.dd = 1.0 / this.n;
            this.rho0 = this.dd * Math.sqrt(this.c - this.n * ProjectionMath.qsfn(Math.sin(this.projectionLatitude), this.e, this.one_es));
        } else {
            if (bl) {
                this.n = 0.5 * (this.n + Math.sin(this.phi2));
            }
            this.n2 = this.n + this.n;
            this.c = d2 * d2 + this.n2 * d;
            this.dd = 1.0 / this.n;
            this.rho0 = this.dd * Math.sqrt(this.c - this.n2 * Math.sin(this.projectionLatitude));
        }
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public int getEPSGCode() {
        return 9822;
    }

    @Override
    public String toString() {
        return "Albers Equal Area";
    }
}

