/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.PseudoCylindricalProjection;

public class AitoffProjection
extends PseudoCylindricalProjection {
    protected static final int AITOFF = 0;
    protected static final int WINKEL = 1;
    private boolean winkel = false;
    private double cosphi1 = 0.0;

    public AitoffProjection() {
    }

    public AitoffProjection(int n, double d) {
        this.projectionLatitude = d;
        this.winkel = n == 1;
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = 0.5 * d;
        double d4 = Math.acos(Math.cos(d2) * Math.cos(d3));
        if (d4 != 0.0) {
            projCoordinate.y = 1.0 / Math.sin(d4);
            projCoordinate.x = 2.0 * d4 * Math.cos(d2) * Math.sin(d3) * projCoordinate.y;
            projCoordinate.y *= d4 * Math.sin(d2);
        } else {
            projCoordinate.y = 0.0;
            projCoordinate.x = 0.0;
        }
        if (this.winkel) {
            projCoordinate.x = (projCoordinate.x + d * this.cosphi1) * 0.5;
            projCoordinate.y = (projCoordinate.y + d2) * 0.5;
        }
        return projCoordinate;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.winkel) {
            this.cosphi1 = 0.6366197723675814;
        }
    }

    @Override
    public boolean hasInverse() {
        return false;
    }

    @Override
    public String toString() {
        return this.winkel ? "Winkel Tripel" : "Aitoff";
    }
}

