/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.io;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.osgeo.proj4j.io.CSVRecordParser;
import org.osgeo.proj4j.io.MetaCRSTestCase;

public class MetaCRSTestFileReader {
    public static final int COL_COUNT = 19;
    private File file;
    private CSVRecordParser lineParser = new CSVRecordParser();

    public MetaCRSTestFileReader(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetaCRSTestCase> readTests() throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.file));
        List<MetaCRSTestCase> list = null;
        try {
            list = this.parseFile(lineNumberReader);
        }
        finally {
            lineNumberReader.close();
        }
        return list;
    }

    private List<MetaCRSTestCase> parseFile(LineNumberReader lineNumberReader) throws IOException {
        String string;
        ArrayList<MetaCRSTestCase> arrayList = new ArrayList<MetaCRSTestCase>();
        boolean bl = false;
        while ((string = lineNumberReader.readLine()) != null) {
            if (string.startsWith("#")) continue;
            if (!bl) {
                bl = true;
                continue;
            }
            arrayList.add(this.parseTest(string));
        }
        return arrayList;
    }

    private MetaCRSTestCase parseTest(String string) {
        String[] stringArray = this.lineParser.parse(string);
        if (stringArray.length != 19) {
            throw new IllegalStateException("Expected 19 columns in file, but found " + stringArray.length);
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        String string5 = stringArray[3];
        String string6 = stringArray[4];
        String string7 = stringArray[5];
        double d = MetaCRSTestFileReader.parseNumber(stringArray[6]);
        double d2 = MetaCRSTestFileReader.parseNumber(stringArray[7]);
        double d3 = MetaCRSTestFileReader.parseNumber(stringArray[8]);
        double d4 = MetaCRSTestFileReader.parseNumber(stringArray[9]);
        double d5 = MetaCRSTestFileReader.parseNumber(stringArray[10]);
        double d6 = MetaCRSTestFileReader.parseNumber(stringArray[11]);
        double d7 = MetaCRSTestFileReader.parseNumber(stringArray[12]);
        double d8 = MetaCRSTestFileReader.parseNumber(stringArray[13]);
        double d9 = MetaCRSTestFileReader.parseNumber(stringArray[14]);
        String string8 = stringArray[15];
        String string9 = stringArray[16];
        String string10 = stringArray[17];
        String string11 = stringArray[18];
        return new MetaCRSTestCase(string2, string3, string4, string5, string6, string7, d, d2, d3, d4, d5, d6, d7, d8, d9, string8, string9, string10, string11);
    }

    private static double parseNumber(String string) {
        if (string == null || string.length() == 0) {
            return Double.NaN;
        }
        return Double.parseDouble(string);
    }
}

