/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxTrackSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditGpxTrack {
    private final List<EditGpxTrackSegment> segments = new ArrayList<EditGpxTrackSegment>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean isDeleted;

    public EditGpxTrack(GpxTrack track) {
        this.attributes.putAll(track.getAttributes());
        for (GpxTrackSegment segment : track.getSegments()) {
            this.segments.add(new EditGpxTrackSegment(segment));
        }
    }

    public List<EditGpxTrackSegment> getSegments() {
        return this.segments;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public GpxTrack createGpxTrack(boolean anonTime) {
        ArrayList<List<WayPoint>> wayPoints = new ArrayList<List<WayPoint>>();
        for (EditGpxTrackSegment segment : this.segments) {
            List<WayPoint> points;
            if (segment.isDeleted() || (points = segment.getNonDeletedWaypoints()).isEmpty()) continue;
            if (anonTime) {
                for (WayPoint w : points) {
                    w.attr.put("time", "1970-01-01T00:00:00.000Z");
                    w.setTime();
                }
            }
            wayPoints.add(points);
        }
        return new ImmutableGpxTrack(wayPoints, this.attributes);
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }
}

