/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.contourmerge;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.contourmerge.ContourMergeModel;
import org.openstreetmap.josm.plugins.contourmerge.ContourMergePlugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ContourMergeMode
extends MapMode {
    private static final Logger logger = Logger.getLogger(ContourMergeMode.class.getName());
    private Collection<OsmPrimitive> selection;
    protected Point dragStart = null;

    public ContourMergeMode(MapFrame mapFrame) {
        super(I18n.tr((String)"Contour Merge"), "contourmerge", I18n.tr((String)"Merge the contour of an area with the contour of another area"), mapFrame, Cursor.getPredefinedCursor(0));
        this.putValue("help", HelpUtil.ht((String)"Plugin/ContourMerge"));
    }

    protected MapView getMapView() {
        return Main.map.mapView;
    }

    public void enterMode() {
        super.enterMode();
        this.getMapView().addMouseListener((MouseListener)((Object)this));
        this.getMapView().addMouseMotionListener((MouseMotionListener)((Object)this));
        ContourMergePlugin.setEnabled(true);
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        if (model != null) {
            model.reset();
        }
        this.selection = model.getLayer().data.getSelected();
        model.getLayer().data.clearSelection();
    }

    public void exitMode() {
        super.exitMode();
        this.getMapView().removeMouseListener((MouseListener)((Object)this));
        this.getMapView().removeMouseMotionListener((MouseMotionListener)((Object)this));
        ContourMergePlugin.setEnabled(false);
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        if (model != null) {
            model.reset();
            model.getLayer().data.setSelected(this.selection);
            this.selection = null;
        }
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    public void mouseReleased(MouseEvent e) {
        if (!ContourMergePlugin.isEnabled()) {
            return;
        }
        this.onDrop(e.getPoint());
    }

    public void mousePressed(MouseEvent e) {
        if (!ContourMergePlugin.isEnabled()) {
            return;
        }
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        if (model == null) {
            return;
        }
        this.onStartDrag(e.getPoint());
    }

    public void mouseClicked(MouseEvent e) {
        if (!ContourMergePlugin.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        if (model == null) {
            return;
        }
        List candidates = this.getMapView().getNearestNodes(e.getPoint(), OsmPrimitive.isSelectablePredicate);
        if (!candidates.isEmpty() && !OsmPrimitive.getFilteredList((Collection)((Node)candidates.get(0)).getReferrers(), Way.class).isEmpty()) {
            model.toggleSelected((Node)candidates.get(0));
        }
        Main.map.mapView.repaint();
    }

    protected BBox buildSnapBBox(Point p) {
        MapView mv = Main.map.mapView;
        LatLon ll = mv.getLatLon(p.x - 3, p.y - 3);
        LatLon ur = mv.getLatLon(p.x + 3, p.y + 3);
        return new BBox(ll, ur);
    }

    protected void showHelpText(String text) {
        Main.map.statusLine.setHelpText(text);
    }

    public void mouseMoved(MouseEvent e) {
        if (!ContourMergePlugin.isEnabled()) {
            return;
        }
        if (ContourMergePlugin.getModelManager().getActiveModel() == null) {
            return;
        }
        if (e.getButton() != 0) {
            return;
        }
        List candidates = this.getMapView().getNearestNodes(e.getPoint(), OsmPrimitive.isSelectablePredicate);
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        this.showHelpText("");
        if (candidates.isEmpty()) {
            model.setFeedbackNode(null);
            WaySegment ws = this.getMapView().getNearestWaySegment(e.getPoint(), OsmPrimitive.isSelectablePredicate);
            if (ws == null) {
                this.getMapView().setCursor(Cursor.getDefaultCursor());
                model.setDragStartFeedbackWaySegment(null);
            } else {
                this.showHelpText(I18n.tr((String)"Drag/drop: drag the way segment an drop it on a target segment"));
                this.getMapView().setCursor(Cursor.getPredefinedCursor(13));
                model.setDragStartFeedbackWaySegment(ws);
            }
        } else {
            if (model.isSelected((Node)candidates.get(0))) {
                this.showHelpText(I18n.tr((String)"Left-Click: deselect node"));
                this.getMapView().setCursor(ImageProvider.getCursor((String)"normal", (String)"deselect_node"));
            } else if (OsmPrimitive.getFilteredList((Collection)((Node)candidates.get(0)).getReferrers(), Way.class).isEmpty()) {
                this.showHelpText(I18n.tr((String)"Can''t select an isolated node"));
                this.getMapView().setCursor(DragSource.DefaultMoveNoDrop);
            } else {
                this.showHelpText(I18n.tr((String)"Left-Click: select node"));
                this.getMapView().setCursor(ImageProvider.getCursor((String)"normal", (String)"select_node"));
            }
            model.setFeedbackNode((Node)candidates.get(0));
        }
        Main.map.mapView.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.onStepDrag(e.getPoint());
    }

    protected void onStartDrag(Point start) {
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        WaySegment ws = this.getMapView().getNearestWaySegment(start, OsmPrimitive.isSelectablePredicate);
        if (ws != null && model.isWaySegmentDragable(ws)) {
            this.dragStart = start;
            this.getMapView().setCursor(Cursor.getPredefinedCursor(13));
            this.showHelpText(I18n.tr((String)"Drag the way segment and drop it on a target segment"));
            model.setDragOffset(new Point(0, 0));
            model.setDragStartFeedbackWaySegment(ws);
            model.setDropFeedbackSegment(null);
        }
    }

    protected void onStepDrag(Point current) {
        WaySegment newDropTargetFeedbackSegment;
        if (this.dragStart == null) {
            return;
        }
        WaySegment ws = this.getMapView().getNearestWaySegment(current, OsmPrimitive.isSelectablePredicate);
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        if (ws == null) {
            this.getMapView().setCursor(Cursor.getPredefinedCursor(13));
            this.showHelpText(I18n.tr((String)"Drag the way segment and drop it on a target segment"));
            newDropTargetFeedbackSegment = null;
        } else if (!model.isPotentialDropTarget(ws)) {
            this.getMapView().setCursor(DragSource.DefaultLinkNoDrop);
            this.showHelpText(I18n.tr((String)"Drag the way segment and drop it on a target segment"));
            newDropTargetFeedbackSegment = null;
        } else {
            this.getMapView().setCursor(DragSource.DefaultLinkDrop);
            this.showHelpText(I18n.tr((String)"Drop to align to the the target segment"));
            newDropTargetFeedbackSegment = ws;
        }
        Point offset = new Point(current.x - this.dragStart.x, current.y - this.dragStart.y);
        model.setDragOffset(offset);
        model.setDropFeedbackSegment(newDropTargetFeedbackSegment);
        Main.map.mapView.repaint();
    }

    protected void onDrop(Point target) {
        if (this.dragStart == null) {
            return;
        }
        WaySegment ws = this.getMapView().getNearestWaySegment(target, OsmPrimitive.isSelectablePredicate);
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        if (model.isPotentialDropTarget(ws)) {
            this.getMapView().setCursor(Cursor.getDefaultCursor());
            Command cmd = model.buildContourAlignCommand();
            if (cmd != null) {
                Main.main.undoRedo.add(cmd);
            }
        }
        this.getMapView().setCursor(Cursor.getDefaultCursor());
        this.showHelpText(I18n.tr((String)"Left-Click: on node to select/unselect; Drag: drag way slice"));
        this.dragStart = null;
        model.setDragStartFeedbackWaySegment(null);
        model.setDropFeedbackSegment(null);
        model.setDragOffset(null);
        Main.map.mapView.repaint();
    }
}

