/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.contourmerge;

import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.contourmerge.WaySlice;
import org.openstreetmap.josm.plugins.contourmerge.util.Assert;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContourMergeModel
implements DataSetListener {
    private static final Logger logger = Logger.getLogger(ContourMergeModel.class.getName());
    private OsmDataLayer layer;
    private Node feedbackNode;
    private WaySegment dragStartFeedbackSegment;
    private WaySegment dropFeedbackSegment;
    private final ArrayList<Node> selectedNodes = new ArrayList();
    private Point dragOffset = null;

    public ContourMergeModel(OsmDataLayer layer) throws IllegalArgumentException {
        Assert.checkArgNotNull(layer, "layer");
        this.layer = layer;
    }

    public OsmDataLayer getLayer() {
        return this.layer;
    }

    public Node getFeedbackNode() {
        return this.feedbackNode;
    }

    public void setFeedbackNode(Node node) {
        this.feedbackNode = node;
    }

    public void reset() {
        this.setFeedbackNode(null);
    }

    public boolean isSelected(Node node) throws IllegalArgumentException {
        Assert.checkArgNotNull(node, "node");
        Assert.checkArg(node.getDataSet() == this.layer.data, "Node must be owned by this contour merge models layer", new Object[0]);
        return this.selectedNodes.contains(node);
    }

    public void selectNode(Node node) throws IllegalArgumentException {
        Assert.checkArgNotNull(node, "node");
        Assert.checkArg(node.getDataSet() == this.layer.data, "Node must be owned by this contour merge models layer", new Object[0]);
        if (!this.isSelected(node)) {
            this.selectedNodes.add(node);
        }
    }

    public void deselectNode(Node node) throws IllegalArgumentException {
        Assert.checkArgNotNull(node, "node");
        Assert.checkArg(node.getDataSet() == this.layer.data, "Node must be owned by this contour merge models layer", new Object[0]);
        this.selectedNodes.remove(node);
    }

    public void toggleSelected(Node node) throws IllegalArgumentException {
        Assert.checkArgNotNull(node, "node");
        Assert.checkArg(node.getDataSet() == this.layer.data, "Node must be owned by this contour merge models layer", new Object[0]);
        if (this.isSelected(node)) {
            this.deselectNode(node);
        } else {
            this.selectNode(node);
        }
    }

    public void deselectAllNodes() {
        this.selectedNodes.clear();
    }

    public List<Node> getSelectedNodes() {
        return Collections.unmodifiableList(this.selectedNodes);
    }

    public void setDragStartFeedbackWaySegment(WaySegment segment) {
        this.dragStartFeedbackSegment = segment;
    }

    public WaySegment getDragStartFeedbackWaySegement() {
        return this.dragStartFeedbackSegment;
    }

    public void setDropFeedbackSegment(WaySegment segment) {
        this.dropFeedbackSegment = segment;
    }

    public WaySegment getDropFeedbackSegment() {
        return this.dropFeedbackSegment;
    }

    protected Set<Way> computeSelectedWays() {
        HashSet<Way> ways = new HashSet<Way>();
        for (Node n : this.selectedNodes) {
            ways.addAll(OsmPrimitive.getFilteredList((Collection)n.getReferrers(), Way.class));
        }
        return ways;
    }

    protected Set<Node> computeSelectedNodesOnWay(Way way) {
        HashSet<Node> nodes = new HashSet<Node>();
        if (way == null) {
            return nodes;
        }
        for (Node n : this.selectedNodes) {
            if (!OsmPrimitive.getFilteredSet((Collection)n.getReferrers(), Way.class).contains(way)) continue;
            nodes.add(n);
        }
        return nodes;
    }

    public boolean isWaySegmentDragable(WaySegment ws) {
        WaySlice slice = this.getWaySliceFromSelectedNodes(ws);
        return slice != null;
    }

    public boolean isPotentialDropTarget(WaySegment ws) {
        if (ws == null) {
            return false;
        }
        WaySlice dropTarget = this.getWaySliceFromSelectedNodes(ws);
        if (dropTarget == null) {
            return false;
        }
        WaySlice dragSource = this.getDragSource();
        if (dragSource == null) {
            return true;
        }
        return !dragSource.getWay().equals((Object)dropTarget.getWay());
    }

    protected List<Integer> computeSelectedNodeIndicesOnWay(Way way) {
        Set<Node> nodes = this.computeSelectedNodesOnWay(way);
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (nodes.isEmpty()) {
            return ret;
        }
        for (Node n : nodes) {
            ret.add(way.getNodes().indexOf(n));
        }
        Collections.sort(ret);
        return ret;
    }

    protected WaySlice getWaySliceFromSelectedNodes(WaySegment referenceSegment) {
        int pos;
        if (referenceSegment == null) {
            return null;
        }
        Way way = referenceSegment.way;
        if (way.isClosed()) {
            int i;
            List<Integer> selIndices = this.computeSelectedNodeIndicesOnWay(way);
            if (selIndices.size() < 2) {
                return null;
            }
            int nn = way.getNodesCount();
            int li = referenceSegment.lowerIndex;
            int lower = -1;
            int upper = nn;
            for (i = li; i >= 0; --i) {
                if (!selIndices.contains(i)) continue;
                lower = i;
                break;
            }
            if (lower == -1) {
                for (i = nn - 1; i > li; --i) {
                    if (!selIndices.contains(i)) continue;
                    lower = i;
                    break;
                }
            }
            for (i = li + 1; i < nn - 1; ++i) {
                if (!selIndices.contains(i)) continue;
                upper = i;
                break;
            }
            if (upper == nn) {
                for (i = 0; i < li; ++i) {
                    if (!selIndices.contains(i)) continue;
                    upper = i;
                    break;
                }
                if (upper == 0) {
                    upper = nn - 1;
                }
            }
            if (lower < upper) {
                if (upper == nn - 1) {
                    return new WaySlice(way, 0, lower, false);
                }
                return new WaySlice(way, lower, upper);
            }
            if (lower == upper) {
                return new WaySlice(way, 0, upper, false);
            }
            return new WaySlice(way, upper, lower, false);
        }
        List<Integer> selIndices = this.computeSelectedNodeIndicesOnWay(referenceSegment.way);
        int nn = way.getNodesCount();
        int li = referenceSegment.lowerIndex;
        int lastPos = nn - 1;
        int lower = 0;
        int upper = lastPos;
        for (pos = li; pos >= 0; --pos) {
            if (!selIndices.contains(pos)) continue;
            lower = pos;
            break;
        }
        for (pos = li + 1; pos <= lastPos; ++pos) {
            if (!selIndices.contains(pos)) continue;
            upper = pos;
            break;
        }
        return new WaySlice(referenceSegment.way, lower, upper);
    }

    public WaySlice getDragSource() {
        if (this.dragStartFeedbackSegment == null) {
            return null;
        }
        return this.getWaySliceFromSelectedNodes(this.dragStartFeedbackSegment);
    }

    public WaySlice getDropTarget() {
        if (this.dropFeedbackSegment == null) {
            return null;
        }
        return this.getWaySliceFromSelectedNodes(this.dropFeedbackSegment);
    }

    public void setDragOffset(Point offset) {
        this.dragOffset = offset;
    }

    public Point getDragOffset() {
        return this.dragOffset;
    }

    public boolean isDragging() {
        return this.dragOffset != null;
    }

    public Command buildContourAlignCommand() {
        WaySlice dragSource = this.getDragSource();
        WaySlice dropTarget = this.getDropTarget();
        if (dragSource == null) {
            return null;
        }
        if (dropTarget == null) {
            return null;
        }
        List<Node> targetNodes = dropTarget.getNodes();
        if (!this.areDirectionAligned(dragSource, dropTarget)) {
            logger.info("not direction aligned !");
            Collections.reverse(targetNodes);
        }
        ArrayList<Object> cmds = new ArrayList<Object>();
        cmds.add(new ChangeCommand((OsmPrimitive)dragSource.getWay(), (OsmPrimitive)dragSource.replaceNodes(targetNodes)));
        for (Node n : dragSource.getNodes()) {
            List parents = n.getReferrers();
            parents.remove(dragSource.getWay());
            if (!parents.isEmpty() || n.isTagged()) continue;
            cmds.add(new DeleteCommand((OsmPrimitive)n));
        }
        SequenceCommand cmd = new SequenceCommand(I18n.tr((String)"Merging Contour"), cmds);
        return cmd;
    }

    protected boolean areDirectionAligned(List<Node> n1, List<Node> n2) {
        Line2D.Double l2;
        EastNorth s1 = n1.get(0).getEastNorth();
        EastNorth s2 = n1.get(n1.size() - 1).getEastNorth();
        EastNorth t1 = n2.get(0).getEastNorth();
        EastNorth t2 = n2.get(n2.size() - 1).getEastNorth();
        Line2D.Double l1 = new Line2D.Double(s1.getX(), s1.getY(), t1.getX(), t1.getY());
        return !l1.intersectsLine(l2 = new Line2D.Double(s2.getX(), s2.getY(), t2.getX(), t2.getY()));
    }

    protected boolean areDirectionAligned(WaySlice dragSource, WaySlice dropTarget) {
        if (dragSource == null) {
            return false;
        }
        if (dropTarget == null) {
            return false;
        }
        return this.areDirectionAligned(dragSource.getNodes(), dropTarget.getNodes());
    }

    protected void ensureSelectedNodesConsistent() {
        Iterator<Node> it = this.selectedNodes.iterator();
        while (it.hasNext()) {
            Node n = it.next();
            if (OsmPrimitive.getFilteredSet((Collection)n.getReferrers(), Way.class).isEmpty()) {
                it.remove();
                continue;
            }
            if (!n.isDeleted()) continue;
            it.remove();
        }
    }

    public void primtivesRemoved(PrimitivesRemovedEvent event) {
        this.ensureSelectedNodesConsistent();
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
        this.ensureSelectedNodesConsistent();
    }

    public void dataChanged(DataChangedEvent event) {
        this.ensureSelectedNodesConsistent();
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void primtivesAdded(PrimitivesAddedEvent event) {
    }

    public void tagsChanged(TagsChangedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }
}

