/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteActionList;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustAction;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapdustActionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane cmpActionList;
    private JList queueList;
    private final List<MapdustAction> actionList;

    public MapdustActionPanel(List<MapdustAction> actionList, String name, MapdustPlugin mapdustPlugin) {
        this.actionList = actionList;
        this.setLayout(new BorderLayout());
        this.addComponents(actionList, mapdustPlugin);
        this.setName(I18n.tr((String)name));
    }

    private void addComponents(List<MapdustAction> list, MapdustPlugin mapdustPlugin) {
        ExecuteActionList action = new ExecuteActionList(mapdustPlugin.getMapdustGUI());
        JToggleButton btnUpload = ComponentUtil.createJButton("Upload list data", null, null, action);
        action.addObserver(mapdustPlugin);
        if (this.cmpActionList == null) {
            this.queueList = ComponentUtil.createJList(list);
            this.cmpActionList = ComponentUtil.createJScrollPane(this.queueList);
        }
        this.add((Component)this.cmpActionList, "Center");
        this.add((Component)btnUpload, "South");
    }

    public List<MapdustAction> getActionList() {
        return this.actionList;
    }

    public JScrollPane getCmpActionList() {
        return this.cmpActionList;
    }

    public JList getQueueList() {
        return this.queueList;
    }
}

