/*
 * Decompiled with CFR 0.152.
 */
package pdfimport.pdfbox;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import pdfimport.PathOptimizer;
import pdfimport.pdfbox.GraphicsProcessor;
import pdfimport.pdfbox.PageDrawer;

public class PdfBoxParser
extends PDFStreamEngine {
    private final PathOptimizer target;

    public PdfBoxParser(PathOptimizer target) {
        this.target = target;
    }

    public void parse(File file, int maxPaths, ProgressMonitor monitor) throws Exception {
        monitor.beginTask(I18n.tr((String)"Parsing PDF", (Object[])new Object[]{1}));
        PDDocument document = PDDocument.load(file);
        if (document.isEncrypted()) {
            throw new Exception(I18n.tr((String)"Encrypted documents not supported."));
        }
        List allPages = document.getDocumentCatalog().getAllPages();
        if (allPages.size() != 1) {
            throw new Exception(I18n.tr((String)"The PDF file must have exactly one page."));
        }
        PDPage page = (PDPage)allPages.get(0);
        PDRectangle pageSize = page.findMediaBox();
        Integer rotationVal = page.getRotation();
        int rotation = 0;
        if (rotationVal != null) {
            rotation = rotationVal;
        }
        GraphicsProcessor p = new GraphicsProcessor(this.target, rotation, maxPaths, monitor);
        PageDrawer drawer = new PageDrawer();
        drawer.drawPage(p, page);
        this.target.bounds = new Rectangle2D.Double(pageSize.getLowerLeftX(), pageSize.getLowerLeftY(), pageSize.getWidth(), pageSize.getHeight());
        monitor.finishTask();
    }
}

