/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.list;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.LibVlcFactory;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.log.Logger;

public class MediaList {
    private final LibVlc libvlc = LibVlcFactory.factory().synchronise().log().create();
    private libvlc_instance_t instance;
    private libvlc_media_list_t mediaListInstance;
    private AtomicBoolean released = new AtomicBoolean();
    private String[] standardMediaOptions;

    public MediaList(libvlc_instance_t instance) {
        this.instance = instance;
        this.createInstance();
    }

    public void setStandardMediaOptions(String ... standardMediaOptions) {
        this.standardMediaOptions = standardMediaOptions;
    }

    public void addMedia(String mrl) {
        Logger.debug("add(mrl={})", mrl);
        this.addMedia(mrl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMedia(String media, String ... mediaOptions) {
        Logger.debug("addMedia(media={}, mediaOptions={})", media, mediaOptions);
        try {
            this.lock();
            libvlc_media_t mediaDescriptor = this.newMediaDescriptor(media, mediaOptions);
            this.libvlc.libvlc_media_list_add_media(this.mediaListInstance, mediaDescriptor);
            this.releaseMediaDescriptor(mediaDescriptor);
        }
        finally {
            this.unlock();
        }
    }

    public void insertMedia(int index, String media) {
        Logger.debug("insertMedia(index={}, media={})", index, media);
        this.insertMedia(index, media, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMedia(int index, String media, String ... mediaOptions) {
        Logger.debug("insertMedia(index={}, media={}, mediaOptions={})", index, media, mediaOptions);
        try {
            this.lock();
            libvlc_media_t mediaDescriptor = this.newMediaDescriptor(media, mediaOptions);
            this.libvlc.libvlc_media_list_insert_media(this.mediaListInstance, mediaDescriptor, index);
            this.releaseMediaDescriptor(mediaDescriptor);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMedia(int index) {
        Logger.debug("removeMedia(index={})", index);
        try {
            this.lock();
            this.libvlc.libvlc_media_list_remove_index(this.mediaListInstance, index);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Logger.debug("size()", new Object[0]);
        try {
            int size;
            this.lock();
            int n = size = this.libvlc.libvlc_media_list_count(this.mediaListInstance);
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isReadOnly() {
        Logger.debug("isReadOnly()", new Object[0]);
        boolean readOnly = this.libvlc.libvlc_media_list_is_readonly(this.mediaListInstance) == 0;
        return readOnly;
    }

    public final void release() {
        Logger.debug("release()", new Object[0]);
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
        }
    }

    private void createInstance() {
        Logger.debug("createInstance()", new Object[0]);
        this.mediaListInstance = this.libvlc.libvlc_media_list_new(this.instance);
    }

    private void destroyInstance() {
        Logger.debug("destroyInstance()", new Object[0]);
        if (this.mediaListInstance != null) {
            this.libvlc.libvlc_media_list_release(this.mediaListInstance);
        }
    }

    private void lock() {
        Logger.debug("lock()", new Object[0]);
        this.libvlc.libvlc_media_list_lock(this.mediaListInstance);
    }

    private void unlock() {
        Logger.debug("unlock()", new Object[0]);
        this.libvlc.libvlc_media_list_unlock(this.mediaListInstance);
    }

    private libvlc_media_t newMediaDescriptor(String media, String ... mediaOptions) {
        Logger.debug("newMediaDescriptor(media={},mediaOptions={})", media, Arrays.toString(mediaOptions));
        libvlc_media_t mediaDescriptor = this.libvlc.libvlc_media_new_path(this.instance, media);
        Logger.debug("mediaDescriptor={}", new Object[]{mediaDescriptor});
        if (this.standardMediaOptions != null) {
            for (String standardMediaOption : this.standardMediaOptions) {
                Logger.debug("standardMediaOption={}", standardMediaOption);
                this.libvlc.libvlc_media_add_option(mediaDescriptor, standardMediaOption);
            }
        }
        if (mediaOptions != null) {
            for (String mediaOption : mediaOptions) {
                Logger.debug("mediaOption={}", mediaOption);
                this.libvlc.libvlc_media_add_option(mediaDescriptor, mediaOption);
            }
        }
        return mediaDescriptor;
    }

    private void releaseMediaDescriptor(libvlc_media_t mediaDescriptor) {
        Logger.debug("releaseMediaDescriptor(mediaDescriptor={})", new Object[]{mediaDescriptor});
        this.libvlc.libvlc_media_release(mediaDescriptor);
    }

    libvlc_media_list_t mediaListInstance() {
        return this.mediaListInstance;
    }
}

