/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.plugin.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.plugins.graphview.plugin.dialogs.AccessParameterDialog;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.GraphViewPreferenceDefaults;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.GraphViewPreferences;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.PreferenceAccessParameters;
import org.openstreetmap.josm.tools.GBC;

public class GraphViewPreferenceEditor
implements PreferenceSetting {
    private File rulesetFolder;
    private Map<String, PreferenceAccessParameters> parameterBookmarks;
    private JPanel preferencePanel;
    private JCheckBox internalRulesetCheckBox;
    private JLabel rulesetFolderLabel;
    private JTextField rulesetFolderTextField;
    private JButton selectRulesetFolderButton;
    private JComboBox bookmarkComboBox;
    private JButton editBookmarkButton;
    private JButton deleteBookmarkButton;
    private JCheckBox separateDirectionsCheckBox;
    private JButton segmentColorButton;
    private JPanel segmentColorField;
    private JButton nodeColorButton;
    private JPanel nodeColorField;
    private final ActionListener internalRulesetActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            GraphViewPreferenceEditor.this.updateRulesetPanel();
        }
    };
    private final ActionListener selectRulesetFolderActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            File initialFCDirectory = GraphViewPreferenceEditor.this.rulesetFolder;
            if (GraphViewPreferenceEditor.this.rulesetFolder.getParentFile() != null) {
                initialFCDirectory = GraphViewPreferenceEditor.this.rulesetFolder.getParentFile();
            }
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            fc.setCurrentDirectory(initialFCDirectory);
            int returnVal = fc.showOpenDialog(GraphViewPreferenceEditor.this.preferencePanel);
            if (returnVal == 0) {
                GraphViewPreferenceEditor.this.rulesetFolder = fc.getSelectedFile();
                GraphViewPreferenceEditor.this.rulesetFolderTextField.setText(GraphViewPreferenceEditor.this.rulesetFolder.getPath());
            }
        }
    };
    private final ActionListener createVehicleActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PreferenceAccessParameters defaultBookmarkParameters = GraphViewPreferenceDefaults.createDefaultBookmarkAccessParameters();
            AccessParameterDialog apd = new AccessParameterDialog(null, false, "new bookmark", GraphViewPreferenceEditor.this.parameterBookmarks.keySet(), defaultBookmarkParameters, new AccessParameterDialog.BookmarkAction(){

                public void execute(String name, PreferenceAccessParameters parameters) {
                    GraphViewPreferenceEditor.this.parameterBookmarks.put(name, parameters);
                    GraphViewPreferenceEditor.this.updateVehiclePanel(name);
                }
            });
            apd.setVisible(true);
        }
    };
    private final ActionListener editVehicleActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (GraphViewPreferenceEditor.this.bookmarkComboBox.getSelectedItem() != null) {
                final String selectedBookmarkName = (String)GraphViewPreferenceEditor.this.bookmarkComboBox.getSelectedItem();
                PreferenceAccessParameters parameters = (PreferenceAccessParameters)GraphViewPreferenceEditor.this.parameterBookmarks.get(selectedBookmarkName);
                LinkedList<String> otherBookmarkNames = new LinkedList<String>();
                for (String bookmarkName : GraphViewPreferenceEditor.this.parameterBookmarks.keySet()) {
                    if (bookmarkName.equals(selectedBookmarkName)) continue;
                    otherBookmarkNames.add(bookmarkName);
                }
                AccessParameterDialog apd = new AccessParameterDialog(null, true, selectedBookmarkName, otherBookmarkNames, parameters, new AccessParameterDialog.BookmarkAction(){

                    public void execute(String name, PreferenceAccessParameters parameters) {
                        GraphViewPreferenceEditor.this.parameterBookmarks.remove(selectedBookmarkName);
                        GraphViewPreferenceEditor.this.parameterBookmarks.put(name, parameters);
                        GraphViewPreferenceEditor.this.updateVehiclePanel(name);
                    }
                });
                apd.setVisible(true);
            }
        }
    };
    private final ActionListener deleteVehicleActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (GraphViewPreferenceEditor.this.bookmarkComboBox.getSelectedItem() != null) {
                String selectedBookmarkName = (String)GraphViewPreferenceEditor.this.bookmarkComboBox.getSelectedItem();
                int userChoice = JOptionPane.showConfirmDialog(GraphViewPreferenceEditor.this.preferencePanel, "Really delete \"" + selectedBookmarkName + "\"?", "Bookmark deletion", 0, 2);
                if (userChoice == 0) {
                    GraphViewPreferenceEditor.this.parameterBookmarks.remove(selectedBookmarkName);
                    GraphViewPreferenceEditor.this.updateVehiclePanel(null);
                }
            }
        }
    };
    private final ActionListener restoreVehicleDefaultsActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int userChoice = JOptionPane.showConfirmDialog(GraphViewPreferenceEditor.this.preferencePanel, "Really restore default bookmarks?\nAll manually added or edited bookmarks will be lost!", "Bookmark reset", 0, 2);
            if (userChoice == 0) {
                GraphViewPreferenceEditor.this.parameterBookmarks.clear();
                GraphViewPreferenceEditor.this.parameterBookmarks.putAll(GraphViewPreferenceDefaults.createDefaultAccessParameterBookmarks());
                GraphViewPreferenceEditor.this.updateVehiclePanel(null);
            }
        }
    };
    private final ActionListener chooseNodeColorActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Color selectedColor = JColorChooser.showDialog(GraphViewPreferenceEditor.this.preferencePanel, "Choose node color", GraphViewPreferenceEditor.this.nodeColorField.getBackground());
            if (selectedColor != null) {
                GraphViewPreferenceEditor.this.nodeColorField.setBackground(selectedColor);
            }
        }
    };
    private final ActionListener chooseSegmentColorActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Color selectedColor = JColorChooser.showDialog(GraphViewPreferenceEditor.this.preferencePanel, "Choose arrow color", GraphViewPreferenceEditor.this.segmentColorField.getBackground());
            if (selectedColor != null) {
                GraphViewPreferenceEditor.this.segmentColorField.setBackground(selectedColor);
            }
        }
    };

    public void addGui(PreferenceTabbedPane gui) {
        this.readPreferences();
        this.preferencePanel = gui.createPreferenceTab("graphview", "Graphview", "Settings for the Graphview plugin that visualizes routing graphs.");
        JPanel mainPanel = this.createMainPanel();
        this.preferencePanel.add((Component)mainPanel, GBC.eol().fill(1));
        this.updateVehiclePanel(GraphViewPreferences.getInstance().getCurrentParameterBookmarkName());
    }

    private void readPreferences() {
        GraphViewPreferences preferences = GraphViewPreferences.getInstance();
        this.rulesetFolder = preferences.getRulesetFolder();
        this.parameterBookmarks = new HashMap<String, PreferenceAccessParameters>(preferences.getParameterBookmarks());
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        GridBagLayout mainLayout = new GridBagLayout();
        mainPanel.setLayout(mainLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        JPanel rulesetPanel = this.createRulesetPanel();
        constraints.gridy = 0;
        mainLayout.setConstraints(rulesetPanel, constraints);
        mainPanel.add(rulesetPanel);
        JPanel vehiclePanel = this.createVehiclePanel();
        constraints.gridy = 1;
        mainLayout.setConstraints(vehiclePanel, constraints);
        mainPanel.add(vehiclePanel);
        JPanel visualizationPanel = this.createVisualizationPanel();
        constraints.gridy = 2;
        mainLayout.setConstraints(visualizationPanel, constraints);
        mainPanel.add(visualizationPanel);
        mainPanel.add(GBC.glue((int)0, (int)0));
        return mainPanel;
    }

    private JPanel createRulesetPanel() {
        JPanel rulesetPanel = new JPanel();
        rulesetPanel.setBorder(BorderFactory.createTitledBorder("ruleset"));
        rulesetPanel.setLayout(new BoxLayout(rulesetPanel, 1));
        this.internalRulesetCheckBox = new JCheckBox("use built-in rulesets");
        this.internalRulesetCheckBox.setSelected(GraphViewPreferences.getInstance().getUseInternalRulesets());
        this.internalRulesetCheckBox.addActionListener(this.internalRulesetActionListener);
        rulesetPanel.add(this.internalRulesetCheckBox);
        this.rulesetFolderLabel = new JLabel("external ruleset directory:");
        rulesetPanel.add(this.rulesetFolderLabel);
        this.rulesetFolderTextField = new JTextField();
        this.rulesetFolderTextField.setText(this.rulesetFolder.getPath());
        this.rulesetFolderTextField.setEditable(false);
        rulesetPanel.add(this.rulesetFolderTextField);
        this.selectRulesetFolderButton = new JButton("select directory");
        this.selectRulesetFolderButton.addActionListener(this.selectRulesetFolderActionListener);
        rulesetPanel.add(this.selectRulesetFolderButton);
        this.updateRulesetPanel();
        return rulesetPanel;
    }

    private JPanel createVehiclePanel() {
        JPanel vehiclePanel = new JPanel();
        vehiclePanel.setBorder(BorderFactory.createTitledBorder("vehicle"));
        vehiclePanel.setLayout(new BoxLayout(vehiclePanel, 1));
        this.bookmarkComboBox = new JComboBox();
        vehiclePanel.add(this.bookmarkComboBox);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton createButton = new JButton("create");
        createButton.addActionListener(this.createVehicleActionListener);
        buttonPanel.add(createButton);
        this.editBookmarkButton = new JButton("edit");
        this.editBookmarkButton.addActionListener(this.editVehicleActionListener);
        buttonPanel.add(this.editBookmarkButton);
        this.deleteBookmarkButton = new JButton("delete");
        this.deleteBookmarkButton.addActionListener(this.deleteVehicleActionListener);
        buttonPanel.add(this.deleteBookmarkButton);
        JButton restoreDefaultsButton = new JButton("restore defaults");
        restoreDefaultsButton.addActionListener(this.restoreVehicleDefaultsActionListener);
        buttonPanel.add(restoreDefaultsButton);
        vehiclePanel.add(buttonPanel);
        return vehiclePanel;
    }

    private JPanel createVisualizationPanel() {
        JPanel visualizationPanel = new JPanel();
        visualizationPanel.setBorder(BorderFactory.createTitledBorder("visualization"));
        visualizationPanel.setLayout(new BoxLayout(visualizationPanel, 1));
        this.separateDirectionsCheckBox = new JCheckBox("draw directions separately");
        this.separateDirectionsCheckBox.setSelected(GraphViewPreferences.getInstance().getSeparateDirections());
        visualizationPanel.add(this.separateDirectionsCheckBox);
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new GridLayout(2, 2));
        Color nodeColor = GraphViewPreferences.getInstance().getNodeColor();
        this.nodeColorButton = new JButton("node color");
        this.nodeColorButton.addActionListener(this.chooseNodeColorActionListener);
        colorPanel.add(this.nodeColorButton);
        this.nodeColorField = new JPanel();
        this.nodeColorField.setBackground(nodeColor);
        colorPanel.add(this.nodeColorField);
        Color segmentColor = GraphViewPreferences.getInstance().getSegmentColor();
        this.segmentColorButton = new JButton("arrow color");
        this.segmentColorButton.addActionListener(this.chooseSegmentColorActionListener);
        colorPanel.add(this.segmentColorButton);
        this.segmentColorField = new JPanel();
        this.segmentColorField.setBackground(segmentColor);
        colorPanel.add(this.segmentColorField);
        visualizationPanel.add(colorPanel);
        return visualizationPanel;
    }

    public boolean ok() {
        GraphViewPreferences preferences = GraphViewPreferences.getInstance();
        preferences.setUseInternalRulesets(this.internalRulesetCheckBox.isSelected());
        preferences.setRulesetFolder(this.rulesetFolder);
        preferences.setParameterBookmarks(this.parameterBookmarks);
        String selectedBookmarkName = (String)this.bookmarkComboBox.getSelectedItem();
        preferences.setCurrentParameterBookmarkName(selectedBookmarkName);
        preferences.setSeparateDirections(this.separateDirectionsCheckBox.isSelected());
        preferences.setNodeColor(this.nodeColorField.getBackground());
        preferences.setSegmentColor(this.segmentColorField.getBackground());
        preferences.distributeChanges();
        return false;
    }

    private void updateRulesetPanel() {
        this.rulesetFolderLabel.setEnabled(!this.internalRulesetCheckBox.isSelected());
        this.rulesetFolderTextField.setEnabled(!this.internalRulesetCheckBox.isSelected());
        this.selectRulesetFolderButton.setEnabled(!this.internalRulesetCheckBox.isSelected());
    }

    private void updateVehiclePanel(String selectedBookmarkName) {
        this.bookmarkComboBox.removeAllItems();
        for (String bookmarkName : this.parameterBookmarks.keySet()) {
            this.bookmarkComboBox.addItem(bookmarkName);
        }
        if (selectedBookmarkName == null) {
            if (this.bookmarkComboBox.getItemCount() > 0) {
                this.bookmarkComboBox.setSelectedIndex(0);
            }
        } else {
            this.bookmarkComboBox.setSelectedItem(selectedBookmarkName);
        }
        this.editBookmarkButton.setEnabled(this.parameterBookmarks.size() > 0);
        this.deleteBookmarkButton.setEnabled(this.parameterBookmarks.size() > 0);
    }
}

