/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photo_geotagging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.plugins.photo_geotagging.ExifGPSTagger;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GeotaggingAction
extends AbstractAction
implements Layer.LayerAction {
    static final boolean debug = false;
    static final String KEEP_BACKUP = "plugins.photo_geotagging.keep_backup";
    static final String CHANGE_MTIME = "plugins.photo_geotagging.change-mtime";
    static final String MTIME_MODE = "plugins.photo_geotagging.mtime-mode";
    static final int MTIME_MODE_GPS = 1;
    static final int MTIME_MODE_PREVIOUS_VALUE = 2;

    public GeotaggingAction() {
        super(I18n.tr((String)"Write coordinates to image header"), ImageProvider.get((String)"geotagging"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        GeoImageLayer layer = this.getLayer();
        ArrayList<ImageEntry> images = new ArrayList<ImageEntry>();
        for (ImageEntry e : layer.getImages()) {
            if (e.getPos() == null || e.getGpsTime() == null) continue;
            images.add(e);
        }
        JPanel cont = new JPanel(new GridBagLayout());
        cont.add((Component)new JLabel(I18n.tr((String)"Write position information into the exif header of the following files:")), GBC.eol());
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        DecimalFormat dFormatter = new DecimalFormat("###0.000000");
        for (ImageEntry e : images) {
            listModel.addElement(e.getFile().getAbsolutePath() + " (" + dFormatter.format(e.getPos().lat()) + "," + dFormatter.format(e.getPos().lon()) + ")");
        }
        JList entryList = new JList(listModel);
        JScrollPane scroll = new JScrollPane(entryList);
        scroll.setPreferredSize(new Dimension(900, 250));
        cont.add((Component)scroll, GBC.eol().fill(1));
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        settingsPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"settings")));
        cont.add((Component)settingsPanel, GBC.eol().insets(3, 10, 3, 0));
        JCheckBox backups = new JCheckBox(I18n.tr((String)"keep backup files"), Main.pref.getBoolean(KEEP_BACKUP, true));
        settingsPanel.add((Component)backups, GBC.eol().insets(3, 3, 0, 0));
        final JCheckBox setMTime = new JCheckBox(I18n.tr((String)"change file modification time:"), Main.pref.getBoolean(CHANGE_MTIME, false));
        settingsPanel.add((Component)setMTime, GBC.std().insets(3, 3, 5, 3));
        String[] mTimeModeArray = new String[]{"----", I18n.tr((String)"to gps time"), I18n.tr((String)"to previous value (unchanged mtime)")};
        final JComboBox<String> mTimeMode = new JComboBox<String>(mTimeModeArray);
        String mTimeModePref = Main.pref.get(MTIME_MODE, null);
        int mTimeIdx = 0;
        if ("gps".equals(mTimeModePref)) {
            mTimeIdx = 1;
        } else if ("previous".equals(mTimeModePref)) {
            mTimeIdx = 2;
        }
        mTimeMode.setSelectedIndex(setMTime.isSelected() ? mTimeIdx : 0);
        settingsPanel.add(mTimeMode, GBC.eol().insets(3, 3, 3, 3));
        setMTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (setMTime.isSelected()) {
                    mTimeMode.setEnabled(true);
                } else {
                    mTimeMode.setSelectedIndex(0);
                    mTimeMode.setEnabled(false);
                }
            }
        });
        setMTime.setSelected(!setMTime.isSelected());
        setMTime.doClick();
        int result = new ExtendedDialog(Main.parent, I18n.tr((String)"Photo Geotagging Plugin"), new String[]{I18n.tr((String)"OK"), I18n.tr((String)"Cancel")}).setButtonIcons(new String[]{"ok.png", "cancel.png"}).setContent((Component)cont).setCancelButton(new Integer[]{2}).setDefaultButton(1).showDialog().getValue();
        if (result != 1) {
            return;
        }
        boolean keep_backup = backups.isSelected();
        boolean change_mtime = setMTime.isSelected();
        Main.pref.put(KEEP_BACKUP, keep_backup);
        Main.pref.put(CHANGE_MTIME, change_mtime);
        if (change_mtime) {
            String mTimeModePref2;
            switch (mTimeMode.getSelectedIndex()) {
                case 1: {
                    mTimeModePref2 = "gps";
                    break;
                }
                case 2: {
                    mTimeModePref2 = "previous";
                    break;
                }
                default: {
                    mTimeModePref2 = null;
                }
            }
            Main.pref.put(MTIME_MODE, mTimeModePref2);
        }
        Main.worker.execute((Runnable)((Object)new GeoTaggingRunnable(images, keep_backup, mTimeMode.getSelectedIndex())));
    }

    private GeoImageLayer getLayer() {
        return (GeoImageLayer)LayerListDialog.getInstance().getModel().getSelectedLayers().get(0);
    }

    private boolean enabled(GeoImageLayer layer) {
        for (ImageEntry e : layer.getImages()) {
            if (e.getPos() == null || e.getGpsTime() == null) continue;
            return true;
        }
        return false;
    }

    public Component createMenuComponent() {
        JMenuItem geotaggingItem = new JMenuItem(this);
        geotaggingItem.setEnabled(this.enabled(this.getLayer()));
        return geotaggingItem;
    }

    public boolean supportLayers(List<Layer> layers) {
        return layers.size() == 1 && layers.get(0) instanceof GeoImageLayer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GeoTaggingRunnable
    extends PleaseWaitRunnable {
        private final List<ImageEntry> images;
        private final boolean keep_backup;
        private final int mTimeMode;
        private boolean cancelled = false;
        private Boolean override_backup = null;
        private File fileFrom;
        private File fileTo;
        private File fileDelete;
        boolean testMTimeReadAndWriteDone = false;

        public GeoTaggingRunnable(List<ImageEntry> images, boolean keep_backup, int mTimeMode) {
            super(I18n.tr((String)"Photo Geotagging Plugin"));
            this.images = images;
            this.keep_backup = keep_backup;
            this.mTimeMode = mTimeMode;
        }

        protected void realRun() {
            this.progressMonitor.subTask(I18n.tr((String)"Writing position information to image files..."));
            this.progressMonitor.setTicksCount(this.images.size());
            for (int i = 0; i < this.images.size(); ++i) {
                if (this.cancelled) {
                    return;
                }
                ImageEntry e = this.images.get(i);
                this.fileFrom = null;
                this.fileTo = null;
                this.fileDelete = null;
                try {
                    if (this.mTimeMode != 0) {
                        this.testMTimeReadAndWrite(e.getFile());
                    }
                    Long mTime = null;
                    if (this.mTimeMode == 2 && (mTime = Long.valueOf(e.getFile().lastModified())).equals(0L)) {
                        throw new IOException(I18n.tr((String)"Could not read mtime."));
                    }
                    this.chooseFiles(e.getFile());
                    if (this.cancelled) {
                        return;
                    }
                    ExifGPSTagger.setExifGPSTag(this.fileFrom, this.fileTo, e.getPos().lat(), e.getPos().lon(), e.getGpsTime().getTime());
                    if (this.mTimeMode == 1) {
                        mTime = e.getGpsTime().getTime();
                    }
                    if (mTime != null && !this.fileTo.setLastModified(mTime)) {
                        throw new IOException(I18n.tr((String)"Could not write mtime."));
                    }
                    this.cleanupFiles();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(Main.parent, ioe.getMessage(), I18n.tr((String)"Error"), 0);
                        }
                    });
                    return;
                }
                this.progressMonitor.worked(1);
            }
        }

        private void chooseFiles(File file) throws IOException {
            if (!this.keep_backup) {
                this.chooseFilesNoBackup(file);
                return;
            }
            File fileBackup = new File(file.getParentFile(), file.getName() + "_");
            if (fileBackup.exists()) {
                this.confirm_override();
                if (this.cancelled) {
                    return;
                }
                if (this.override_backup.booleanValue()) {
                    if (!fileBackup.delete()) {
                        throw new IOException(I18n.tr((String)"File could not be deleted!"));
                    }
                } else {
                    this.chooseFilesNoBackup(file);
                    return;
                }
            }
            if (!file.renameTo(fileBackup)) {
                throw new IOException(I18n.tr((String)"Could not rename file!"));
            }
            this.fileFrom = fileBackup;
            this.fileTo = file;
            this.fileDelete = null;
        }

        private void chooseFilesNoBackup(File file) throws IOException {
            File fileTmp = new File(file.getParentFile(), "img" + UUID.randomUUID() + ".jpg");
            if (!file.renameTo(fileTmp)) {
                throw new IOException(I18n.tr((String)"Could not rename file!"));
            }
            this.fileFrom = fileTmp;
            this.fileTo = file;
            this.fileDelete = fileTmp;
        }

        private void confirm_override() {
            if (this.override_backup != null) {
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JLabel l = new JLabel(I18n.tr((String)"<html><h3>There are old backup files in the image directory!</h3>"));
                        l.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
                        int override = new ExtendedDialog(((PleaseWaitProgressMonitor)GeoTaggingRunnable.this.progressMonitor).getDialog(), I18n.tr((String)"Override old backup files?"), new String[]{I18n.tr((String)"Cancel"), I18n.tr((String)"Keep old backups and continue"), I18n.tr((String)"Override")}).setButtonIcons(new String[]{"cancel.png", "ok.png", "dialogs/delete.png"}).setContent((Component)l).setCancelButton(new Integer[]{1}).setDefaultButton(2).showDialog().getValue();
                        if (override == 2) {
                            GeoTaggingRunnable.this.override_backup = false;
                        } else if (override == 3) {
                            GeoTaggingRunnable.this.override_backup = true;
                        } else {
                            GeoTaggingRunnable.this.cancelled = true;
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println(e);
                this.cancelled = true;
            }
        }

        private void cleanupFiles() throws IOException {
            if (this.fileDelete != null && !this.fileDelete.delete()) {
                throw new IOException(I18n.tr((String)"Could not delete temporary file!"));
            }
        }

        private void testMTimeReadAndWrite(File file) throws IOException {
            if (this.testMTimeReadAndWriteDone) {
                return;
            }
            File fileTest = File.createTempFile("geo", ".txt", file.getParentFile());
            long mTimeTest = fileTest.lastModified();
            if (mTimeTest == 0L) {
                throw new IOException(I18n.tr((String)"Test failed: Could not read mtime."));
            }
            if (!fileTest.setLastModified(mTimeTest)) {
                throw new IOException(I18n.tr((String)"Test failed: Could not write mtime."));
            }
            if (!fileTest.delete()) {
                throw new IOException(I18n.tr((String)"Could not delete temporary file!"));
            }
            this.testMTimeReadAndWriteDone = true;
        }

        protected void finish() {
        }

        protected void cancel() {
            this.cancelled = true;
        }
    }
}

