/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.alignways;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.alignways.AlignWaysPlugin;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSegmentMgr;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSelAlgnState;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSelBothState;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSelNoneState;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSelRefState;
import org.openstreetmap.josm.plugins.alignways.AlignWaysState;
import org.openstreetmap.josm.plugins.alignways.AlignWaysTipsPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AlignWaysMode
extends MapMode {
    private static final long serialVersionUID = -1090955708412011141L;
    private final AlignWaysState noneSelected = new AlignWaysSelNoneState();
    private final AlignWaysState referenceSelected = new AlignWaysSelRefState();
    private final AlignWaysState aligneeSelected = new AlignWaysSelAlgnState();
    private final AlignWaysState bothSelected = new AlignWaysSelBothState();
    private AlignWaysState currentState;
    private AlignWaysSegmentMgr awSegs;
    boolean tipShown = false;

    public AlignWaysMode(MapFrame mapFrame, String name, String desc) {
        super(I18n.tr((String)name), "alignways.png", I18n.tr((String)desc), Shortcut.registerShortcut((String)"mapmode:alignways", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Align Ways")}), (int)78, (int)3, (int)1), mapFrame, Cursor.getPredefinedCursor(0));
    }

    public void enterMode() {
        super.enterMode();
        boolean showTips = Boolean.parseBoolean(Main.pref.get("alignways.showtips", "true"));
        if (showTips && !this.tipShown) {
            this.showTips();
        }
        this.awSegs = AlignWaysSegmentMgr.getInstance(Main.map.mapView);
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        this.setCurrentState(this.noneSelected);
    }

    public void exitMode() {
        super.exitMode();
        this.setCurrentState(this.noneSelected);
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        AlignWaysPlugin.getAwAction().setEnabled(false);
    }

    public void mouseClicked(MouseEvent e) {
        boolean altPressed;
        boolean ctrlPressed = (e.getModifiers() & 2) != 0;
        boolean bl = altPressed = (e.getModifiers() & 0x28) != 0;
        if (e.getButton() == 1) {
            if (altPressed) {
                this.currentState.altLClick(this);
            } else {
                Point clickedPoint = new Point(e.getX(), e.getY());
                if (!ctrlPressed) {
                    if (this.awSegs.algnUpdate(clickedPoint)) {
                        this.currentState.leftClick(this);
                    }
                } else if (this.awSegs.refUpdate(clickedPoint)) {
                    this.currentState.ctrlLClick(this);
                }
            }
        }
        if (this.currentState == this.bothSelected) {
            AlignWaysPlugin.getAwAction().setEnabled(true);
        } else {
            AlignWaysPlugin.getAwAction().setEnabled(false);
        }
        Main.map.mapView.repaint();
    }

    public void setCurrentState(AlignWaysState currentState) {
        this.currentState = currentState;
        currentState.setHelpText();
        if (currentState == this.noneSelected) {
            this.awSegs.cleanupWays();
            if (AlignWaysMode.getCurrentDataSet() != null) {
                AlignWaysMode.getCurrentDataSet().clearSelection();
            }
        }
    }

    public AlignWaysState getNoneSelected() {
        return this.noneSelected;
    }

    public AlignWaysState getReferenceSelected() {
        return this.referenceSelected;
    }

    public AlignWaysState getAligneeSelected() {
        return this.aligneeSelected;
    }

    public AlignWaysState getBothSelected() {
        return this.bothSelected;
    }

    public AlignWaysState getCurrentState() {
        return this.currentState;
    }

    private void showTips() {
        AlignWaysTipsPanel atd = new AlignWaysTipsPanel();
        Object[] okButton = new Object[]{I18n.tr((String)"I''m ready!")};
        JOptionPane tipPane = new JOptionPane(atd, -1, -1, null, okButton, okButton[0]);
        JDialog tipDialog = tipPane.createDialog(Main.parent, I18n.tr((String)"AlignWays Tips"));
        tipDialog.setResizable(true);
        tipDialog.setVisible(true);
        this.tipShown = true;
        tipDialog.dispose();
        Main.pref.put("alignways.showtips", !atd.isChkBoxSelected());
    }
}

