/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.DirectUpload;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.plugins.DirectUpload.UploadOsmConnection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UrlLabel;

public class UploadDataGui
extends ExtendedDialog {
    private JMultilineLabel OutputDisplay = new JMultilineLabel(" ");
    private HistoryComboBox descriptionField;
    private HistoryComboBox tagsField;
    private JComboBox visibilityCombo;
    private static final String API_VERSION = "0.6";
    private static final String BOUNDARY = "----------------------------d10f7aa230e8";
    private static final String LINE_END = "\r\n";
    private static final String uploadTraceText = I18n.tr((String)"Upload Trace");
    private boolean cancelled = false;

    public UploadDataGui() {
        super(Main.parent, I18n.tr((String)"Upload Traces"), new String[]{uploadTraceText, I18n.tr((String)"Cancel")}, true);
        JPanel content = this.initComponents();
        GpxData gpxData = UploadOsmConnection.getInstance().autoSelectTrace();
        this.initTitleAndDescriptionFromGpxData(gpxData);
        this.setContent(content);
        this.setButtonIcons(new String[]{"uploadtrace.png", "cancel.png"});
        this.setupDialog();
        ((JButton)this.buttons.get(0)).setEnabled(gpxData != null);
    }

    private JPanel initComponents() {
        JLabel visibilityLabel = new JLabel(I18n.tr((String)"Visibility"));
        visibilityLabel.setToolTipText(I18n.tr((String)"Defines the visibility of your trace for other OSM users."));
        this.visibilityCombo = new JComboBox();
        this.visibilityCombo.setEditable(false);
        for (visibility v : visibility.values()) {
            this.visibilityCombo.addItem(v.description);
        }
        this.visibilityCombo.setSelectedItem(visibility.valueOf((String)Main.pref.get((String)"directupload.visibility.last-used", (String)visibility.PRIVATE.name())).description);
        UrlLabel visiUrl = new UrlLabel(I18n.tr((String)"http://wiki.openstreetmap.org/wiki/Visibility_of_GPS_traces"), I18n.tr((String)"(What does that mean?)"));
        JLabel descriptionLabel = new JLabel(I18n.tr((String)"Description"));
        this.descriptionField = new HistoryComboBox();
        this.descriptionField.setToolTipText(I18n.tr((String)"Please enter Description about your trace."));
        LinkedList descHistory = new LinkedList(Main.pref.getCollection("directupload.description.history", new LinkedList()));
        Collections.reverse(descHistory);
        this.descriptionField.setPossibleItems(descHistory);
        JLabel tagsLabel = new JLabel(I18n.tr((String)"Tags (comma delimited)"));
        this.tagsField = new HistoryComboBox();
        this.tagsField.setToolTipText(I18n.tr((String)"Please enter tags about your trace."));
        LinkedList tagsHistory = new LinkedList(Main.pref.getCollection("directupload.tags.history", new LinkedList()));
        Collections.reverse(tagsHistory);
        this.tagsField.setPossibleItems(tagsHistory);
        JPanel p = new JPanel(new GridBagLayout());
        this.OutputDisplay.setMaxWidth(this.findMaxDialogSize().width - 10);
        p.add((Component)this.OutputDisplay, GBC.eol());
        p.add((Component)tagsLabel, GBC.eol().insets(0, 10, 0, 0));
        p.add((Component)this.tagsField, GBC.eol().fill(2));
        p.add((Component)descriptionLabel, GBC.eol().insets(0, 10, 0, 0));
        p.add((Component)this.descriptionField, GBC.eol().fill(2));
        p.add((Component)visibilityLabel, GBC.std().insets(0, 10, 0, 0));
        p.add((Component)visiUrl, GBC.eol().insets(0, 10, 0, 0));
        p.add((Component)this.visibilityCombo, GBC.eol());
        return p;
    }

    private void initTitleAndDescriptionFromGpxData(GpxData gpxData) {
        String title;
        String description;
        try {
            description = gpxData.storageFile.getName().replaceAll("[&?/\\\\]", " ").replaceAll("(\\.[^.]*)$", "");
            title = I18n.tr((String)"Selected track: {0}", (Object[])new Object[]{gpxData.storageFile.getName()});
        }
        catch (Exception e) {
            description = new SimpleDateFormat("yyMMddHHmmss").format(new Date());
            title = I18n.tr((String)"No GPX layer selected. Cannot upload a trace.");
        }
        this.OutputDisplay.setText(title);
        this.descriptionField.setText(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(String description, String tags, String visi, GpxData gpxData, ProgressMonitor progressMonitor) throws IOException {
        progressMonitor.beginTask(I18n.tr((String)"Uploading trace ..."));
        try {
            if (this.checkForErrors(description, gpxData)) {
                return;
            }
            description = description.replaceAll("[&?/\\\\]", " ");
            tags = tags.replaceAll("[&?/\\\\.;]", " ");
            progressMonitor.indeterminateSubTask(I18n.tr((String)"Connecting..."));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeGpxFile(baos, "file", gpxData);
            this.writeField(baos, "description", description);
            this.writeField(baos, "tags", tags != null && tags.length() > 0 ? tags : "");
            this.writeField(baos, "visibility", visi);
            this.writeString(baos, "------------------------------d10f7aa230e8--\r\n");
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            HttpURLConnection conn = this.setupConnection(baos.size());
            progressMonitor.setTicksCount(baos.size());
            progressMonitor.subTask(null);
            this.flushToServer(bais, conn.getOutputStream(), progressMonitor);
            if (this.cancelled) {
                conn.disconnect();
                this.OutputDisplay.setText(I18n.tr((String)"Upload cancelled"));
                ((JButton)this.buttons.get(0)).setEnabled(true);
                this.cancelled = false;
            } else {
                boolean success = this.finishUpConnection(conn);
                ((JButton)this.buttons.get(0)).setEnabled(!success);
                if (success) {
                    ((JButton)this.buttons.get(1)).setText(I18n.tr((String)"Close"));
                }
            }
        }
        catch (Exception e) {
            this.OutputDisplay.setText(I18n.tr((String)"Error while uploading"));
            e.printStackTrace();
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private HttpURLConnection setupConnection(int contentLength) throws Exception {
        URL url = new URL("http://www.openstreetmap.org/api/0.6/gpx/create");
        HttpURLConnection c = (HttpURLConnection)url.openConnection();
        c.setFixedLengthStreamingMode(contentLength);
        c.setConnectTimeout(15000);
        c.setRequestMethod("POST");
        c.setDoOutput(true);
        UploadOsmConnection.getInstance().addAuthHack(c);
        c.addRequestProperty("Content-Type", "multipart/form-data; boundary=----------------------------d10f7aa230e8");
        c.addRequestProperty("Connection", "close");
        c.addRequestProperty("Expect", "");
        c.connect();
        return c;
    }

    private boolean finishUpConnection(HttpURLConnection c) throws Exception {
        String returnMsg = c.getResponseMessage();
        boolean success = returnMsg.equals("OK");
        if (c.getResponseCode() != 200 && c.getHeaderField("Error") != null) {
            returnMsg = returnMsg + "\n" + c.getHeaderField("Error");
        }
        this.OutputDisplay.setText(success ? I18n.tr((String)"GPX upload was successful") : I18n.tr((String)"Upload failed. Server returned the following message: ") + returnMsg);
        c.disconnect();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushToServer(InputStream in, OutputStream out, ProgressMonitor progressMonitor) throws Exception {
        byte[] buffer = new byte[10000];
        int cur = 0;
        InputStream inputStream = in;
        synchronized (inputStream) {
            int nread;
            while ((nread = in.read(buffer, 0, buffer.length)) >= 0) {
                out.write(buffer, 0, nread);
                out.flush();
                progressMonitor.worked(nread);
                progressMonitor.subTask(this.getProgressText(cur += nread, progressMonitor));
                if (!this.cancelled) continue;
            }
        }
        if (!this.cancelled) {
            out.flush();
        }
        progressMonitor.subTask("Waiting for server reply...");
        buffer = null;
    }

    private String getProgressText(int cur, ProgressMonitor progressMonitor) {
        int max = progressMonitor.getTicksCount();
        int percent = Math.round(cur * 100 / max);
        return I18n.tr((String)"Uploading GPX track: {0}% ({1} of {2})", (Object[])new Object[]{percent, this.formatBytes(cur), this.formatBytes(max)});
    }

    private String formatBytes(int bytes) {
        return bytes > 1000000 ? new DecimalFormat("0.00").format((double)Math.round(bytes / 10000) / 100.0) + " MB" : (bytes > 1000 ? Math.round(bytes / 1000) + " kB" : bytes + " B");
    }

    private boolean checkForErrors(String description, GpxData gpxData) {
        String errors = "";
        if (description == null || description.length() == 0) {
            errors = errors + I18n.tr((String)"No description provided. Please provide some description.");
        }
        if (gpxData == null) {
            errors = errors + I18n.tr((String)"No GPX layer selected. Cannot upload a trace.");
        }
        this.OutputDisplay.setText(errors);
        return errors.length() > 0;
    }

    private void setupUpload() {
        final GpxData gpxData = UploadOsmConnection.getInstance().autoSelectTrace();
        if (gpxData == null) {
            return;
        }
        ((JButton)this.buttons.get(0)).setEnabled(false);
        Main.pref.put("directupload.visibility.last-used", visibility.desc2visi(this.visibilityCombo.getSelectedItem().toString()).name());
        this.descriptionField.addCurrentItemToHistory();
        Main.pref.putCollection("directupload.description.history", (Collection)this.descriptionField.getHistory());
        this.tagsField.addCurrentItemToHistory();
        Main.pref.putCollection("directupload.tags.history", (Collection)this.tagsField.getHistory());
        PleaseWaitRunnable uploadTask = new PleaseWaitRunnable(I18n.tr((String)"Uploading GPX Track")){

            protected void realRun() throws IOException {
                UploadDataGui.this.upload(UploadDataGui.this.descriptionField.getText(), UploadDataGui.this.tagsField.getText(), visibility.desc2visi(UploadDataGui.this.visibilityCombo.getSelectedItem()).toString(), gpxData, this.progressMonitor.createSubTaskMonitor(-1, false));
            }

            protected void finish() {
            }

            protected void cancel() {
                UploadDataGui.this.cancelled = true;
            }
        };
        Main.worker.execute((Runnable)uploadTask);
    }

    private void writeField(ByteArrayOutputStream baos, String name, String value) throws IOException {
        this.writeBoundary(baos);
        this.writeString(baos, "Content-Disposition: form-data; name=\"" + name + "\"");
        this.writeLineEnd(baos);
        this.writeLineEnd(baos);
        baos.write(value.getBytes("UTF-8"));
        this.writeLineEnd(baos);
    }

    private void writeGpxFile(ByteArrayOutputStream baos, String name, GpxData gpxData) throws IOException {
        this.writeBoundary(baos);
        this.writeString(baos, "Content-Disposition: form-data; name=\"" + name + "\"; ");
        this.writeString(baos, "filename=\"" + gpxData.storageFile.getName() + "\"");
        this.writeLineEnd(baos);
        this.writeString(baos, "Content-Type: application/octet-stream");
        this.writeLineEnd(baos);
        this.writeLineEnd(baos);
        new GpxWriter((OutputStream)baos).write(gpxData);
        this.writeLineEnd(baos);
    }

    private void writeString(ByteArrayOutputStream baos, String s) {
        try {
            baos.write(s.getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeLineEnd(ByteArrayOutputStream baos) {
        this.writeString(baos, LINE_END);
    }

    private void writeBoundary(ByteArrayOutputStream baos) {
        this.writeString(baos, "------------------------------d10f7aa230e8");
        this.writeLineEnd(baos);
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        String a = evt.getActionCommand();
        if (uploadTraceText.equals(a)) {
            this.setupUpload();
        } else {
            this.setVisible(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum visibility {
        PRIVATE(I18n.tr((String)"Private (only shared as anonymous, unordered points)")),
        PUBLIC(I18n.tr((String)"Public (shown in trace list and as anonymous, unordered points)")),
        TRACKABLE(I18n.tr((String)"Trackable (only shared as anonymous, ordered points with timestamps)")),
        IDENTIFIABLE(I18n.tr((String)"Identifiable (shown in trace list and as identifiable, ordered points with timestamps)"));

        public final String description;

        private visibility(String description) {
            this.description = description;
        }

        public static visibility desc2visi(Object desc) {
            for (visibility v : visibility.values()) {
                if (!desc.equals(v.description)) continue;
                return v;
            }
            return null;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

