/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.net.URI;
import java.text.DateFormat;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.plugins.mapdust.util.Configuration;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class MapdustBugDetailsPanel
extends JPanel
implements HyperlinkListener {
    private static final long serialVersionUID = 1L;
    private final MapdustBug bug;

    public MapdustBugDetailsPanel(MapdustBug bug) {
        this.bug = bug;
        this.setLayout(new GridLayout(7, 2));
        this.addComponents();
        this.setBackground(Color.white);
    }

    private void addComponents() {
        Font fontLabel = new Font("Times New Roman", 1, 12);
        Font fontLabelVal = new Font("Times New Roman", 0, 12);
        DateFormat df = DateFormat.getDateInstance(2, Locale.getDefault());
        this.add(ComponentUtil.createJLabel("Id: ", fontLabel, null));
        String idStr = this.bug != null ? this.bug.getId().toString() : "";
        String txt = "<html>";
        txt = txt + "<font style='font-size:10px' face='Times New Roman'>";
        txt = txt + "<a href='' target='_blank'>" + idStr + "</a>";
        txt = txt + "</font></html>";
        JEditorPane txtId = new JEditorPane("text/html", "");
        txtId.setEditorKit(new HTMLEditorKit());
        txtId.setEditable(false);
        txtId.setText(txt);
        txtId.setPreferredSize(new Dimension(100, 20));
        txtId.addHyperlinkListener(this);
        this.add(txtId);
        this.add(ComponentUtil.createJLabel("Type: ", fontLabel, null));
        String typeStr = this.bug != null ? this.bug.getType().getValue() : "";
        this.add(ComponentUtil.createJLabel(typeStr, fontLabelVal, null));
        this.add(ComponentUtil.createJLabel("Status: ", fontLabel, null));
        String statusStr = this.bug != null ? this.bug.getStatus().getValue() : "";
        this.add(ComponentUtil.createJLabel(statusStr, fontLabelVal, null));
        this.add(ComponentUtil.createJLabel("Source: ", fontLabel, null));
        String sourceStr = this.bug != null ? this.bug.getSource() : "";
        this.add(ComponentUtil.createJLabel(sourceStr, fontLabelVal, null));
        this.add(ComponentUtil.createJLabel("Created by: ", fontLabel, null));
        String nicknameStr = this.bug != null ? this.bug.getNickname() : "";
        this.add(ComponentUtil.createJLabel(nicknameStr, fontLabelVal, null));
        this.add(ComponentUtil.createJLabel("Date created: ", fontLabel, null));
        String dateCreatedStr = this.bug != null ? df.format(this.bug.getDateCreated()) : "";
        this.add(ComponentUtil.createJLabel(dateCreatedStr, fontLabelVal, null));
        this.add(ComponentUtil.createJLabel("Date updated: ", fontLabel, null));
        String dateUpdatedStr = this.bug != null ? df.format(this.bug.getDateUpdated()) : "";
        this.add(ComponentUtil.createJLabel(dateUpdatedStr, fontLabelVal, null));
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String bugDetailsUrl = null;
            if (this.bug != null) {
                String mapdustSite = Configuration.getInstance().getMapdustBugDetailsUrl();
                bugDetailsUrl = mapdustSite + this.bug.getId().toString();
            }
            if (bugDetailsUrl != null) {
                try {
                    OpenBrowser.displayUrl((URI)new URI(bugDetailsUrl));
                }
                catch (Exception e) {
                    String errorMessage = "Error opening the MapDust bug ";
                    errorMessage = errorMessage + "details page";
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage), I18n.tr((String)"Error"), 0);
                }
            }
        }
    }
}

