/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustActionPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustBugPropertiesPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustActionListObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugDetailsObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugDetailsObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustInitialUpdateObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustInitialUpdateObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustAction;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapdustGUI
extends ToggleDialog
implements MapdustActionListObserver,
MapdustBugDetailsObservable,
MapdustInitialUpdateObservable {
    private static final long serialVersionUID = 1L;
    private final ArrayList<MapdustBugDetailsObserver> bugDetailsObservers = new ArrayList();
    private final ArrayList<MapdustInitialUpdateObserver> initialUpdateObservers = new ArrayList();
    private MapdustPanel panel;
    private MapdustActionPanel queuePanel;
    private JTabbedPane tabbedPane;
    private MapdustPlugin mapdustPlugin;
    private MapdustBugPropertiesPanel detailsPanel;
    private JPanel mainPanel;
    private boolean downloaded = false;

    public MapdustGUI(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight, MapdustPlugin mapdustPlugin) {
        super(I18n.tr((String)name), iconName, I18n.tr((String)tooltip), shortcut, preferredHeight);
        this.mapdustPlugin = mapdustPlugin;
    }

    public synchronized void update(List<MapdustBug> mapdustBugs, MapdustPlugin mapdustPlugin) {
        this.mapdustPlugin = mapdustPlugin;
        String pluginState = Main.pref.get("mapdust.pluginState");
        if (pluginState.equals(MapdustPluginState.ONLINE.getValue())) {
            MapdustBug selectedBug;
            if (this.tabbedPane != null) {
                this.remove(this.mainPanel);
                this.queuePanel = null;
            } else if (this.mainPanel != null) {
                this.remove(this.mainPanel);
            }
            this.panel = new MapdustPanel(mapdustBugs, "Bug reports", mapdustPlugin);
            MapdustBug mapdustBug = selectedBug = mapdustBugs != null && mapdustBugs.size() > 0 ? mapdustBugs.get(0) : null;
            if (this.detailsPanel == null) {
                this.detailsPanel = new MapdustBugPropertiesPanel(selectedBug);
                this.panel.addObserver(this.detailsPanel);
                this.addObserver(this.detailsPanel);
            }
            this.notifyObservers(selectedBug);
            this.panel.addObserver(this.detailsPanel);
            this.mainPanel = new JPanel();
            this.mainPanel.setAutoscrolls(true);
            this.mainPanel.setLayout(new BorderLayout());
            if (mapdustBugs != null) {
                this.mainPanel.add((Component)this.detailsPanel, "North");
            }
            this.mainPanel.add((Component)this.panel, "Center");
            this.add(this.mainPanel, "Center");
        } else {
            MapdustBug selectedBug;
            ArrayList<MapdustAction> list = new ArrayList();
            if (this.queuePanel == null) {
                this.remove(this.mainPanel);
            } else {
                list = this.queuePanel.getActionList();
                this.remove(this.mainPanel);
            }
            this.tabbedPane = new JTabbedPane();
            this.queuePanel = new MapdustActionPanel(list, "Offline Contribution", mapdustPlugin);
            this.panel = new MapdustPanel(mapdustBugs, "Bug reports (offline)", mapdustPlugin);
            MapdustBug mapdustBug = selectedBug = mapdustBugs != null && mapdustBugs.size() > 0 ? mapdustBugs.get(0) : null;
            if (this.detailsPanel == null) {
                this.detailsPanel = new MapdustBugPropertiesPanel(selectedBug);
                this.panel.addObserver(this.detailsPanel);
                this.addObserver(this.detailsPanel);
            }
            this.notifyObservers(selectedBug);
            this.panel.addObserver(this.detailsPanel);
            this.mainPanel = new JPanel();
            this.mainPanel.setAutoscrolls(true);
            this.mainPanel.setLayout(new BorderLayout());
            if (mapdustBugs != null) {
                this.mainPanel.add((Component)this.detailsPanel, "North");
            }
            this.tabbedPane.add((Component)this.panel, 0);
            this.tabbedPane.add(this.queuePanel);
            this.mainPanel.add((Component)this.tabbedPane, "Center");
            this.add(this.mainPanel, "Center");
        }
    }

    @Override
    public synchronized void addAction(MapdustAction action) {
        List<MapdustAction> list = this.queuePanel.getActionList();
        List<MapdustBug> mapdustBugs = this.panel.getMapdustBugsList();
        mapdustBugs = this.modifyBug(mapdustBugs, action.getMapdustBug());
        if (this.mainPanel != null) {
            this.remove(this.mainPanel);
        }
        this.tabbedPane = new JTabbedPane();
        list.add(action);
        this.queuePanel = new MapdustActionPanel(list, "Offline Contribution", this.mapdustPlugin);
        this.panel = new MapdustPanel(mapdustBugs, "Bug reports (offline)", this.mapdustPlugin);
        this.mainPanel = new JPanel();
        this.mainPanel.setAutoscrolls(true);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.detailsPanel, "North");
        this.tabbedPane.add((Component)this.panel, 0);
        this.tabbedPane.add(this.queuePanel);
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.add(this.mainPanel, "Center");
        this.revalidate();
    }

    public void disableBtnPanel() {
        this.panel.getBtnPanel().getBtnWorkOffline().setEnabled(false);
        this.panel.getBtnPanel().getBtnRefresh().setEnabled(false);
        this.panel.getBtnPanel().getBtnAddComment().setEnabled(false);
        this.panel.getBtnPanel().getBtnFixBugReport().setEnabled(false);
        this.panel.getBtnPanel().getBtnInvalidateBugReport().setEnabled(false);
        this.panel.getBtnPanel().getBtnReOpenBugReport().setEnabled(false);
    }

    private List<MapdustBug> modifyBug(List<MapdustBug> mapdustBugs, MapdustBug modifiedBug) {
        int index = -1;
        for (int i = 0; i < mapdustBugs.size(); ++i) {
            if (modifiedBug.getId() == null || !mapdustBugs.get(i).getId().equals(modifiedBug.getId())) continue;
            index = i;
        }
        if (index != -1) {
            mapdustBugs.remove(index);
            mapdustBugs.add(0, modifiedBug);
        }
        return mapdustBugs;
    }

    public void showDialog() {
        if (!this.downloaded) {
            this.notifyObservers();
            this.downloaded = true;
        }
        super.showDialog();
    }

    @Override
    public void addObserver(MapdustBugDetailsObserver observer) {
        if (!this.bugDetailsObservers.contains(observer)) {
            this.bugDetailsObservers.add(observer);
        }
    }

    @Override
    public void addObserver(MapdustInitialUpdateObserver observer) {
        if (!this.initialUpdateObservers.contains(observer)) {
            this.initialUpdateObservers.add(observer);
        }
    }

    @Override
    public void removeObserver(MapdustBugDetailsObserver observer) {
        this.bugDetailsObservers.remove(observer);
    }

    @Override
    public void removeObserver(MapdustInitialUpdateObserver observer) {
        this.initialUpdateObservers.remove(observer);
    }

    @Override
    public void notifyObservers(MapdustBug mapdustBug) {
        Iterator<MapdustBugDetailsObserver> elements = this.bugDetailsObservers.iterator();
        while (elements.hasNext()) {
            elements.next().showDetails(mapdustBug);
        }
    }

    @Override
    public void notifyObservers() {
        Iterator<MapdustInitialUpdateObserver> elements = this.initialUpdateObservers.iterator();
        while (elements.hasNext()) {
            elements.next().initialUpdate();
        }
    }

    public MapdustPanel getPanel() {
        return this.panel;
    }

    public MapdustActionPanel getQueuePanel() {
        return this.queuePanel;
    }
}

