/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.piclayer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;

public class PicLayerFromFile
extends PicLayerAbstract {
    private File m_file;
    private String m_tooltiptext;

    public PicLayerFromFile(File file) {
        this.m_file = file;
        this.m_tooltiptext = this.m_file.getAbsolutePath();
        this.setName(this.m_file.getName());
    }

    protected String getFilePath() {
        return this.m_file.getAbsolutePath();
    }

    public File getDefaultCalPath() {
        File calFile = new File(this.m_file + ".cal");
        return calFile;
    }

    protected Image createImage() throws IOException {
        BufferedImage image = null;
        image = ImageIO.read(this.m_file);
        File calFile = this.getDefaultCalPath();
        if (calFile.exists()) {
            String prefkey = "piclayer.autoloadcal";
            String policy = Main.pref.get(prefkey, "");
            policy = policy.trim().toLowerCase();
            boolean loadcal = false;
            String msg = I18n.tr((String)"A calibration file associated to the picture file was found:") + "\n" + calFile.getName();
            if (policy.equals("yes")) {
                loadcal = true;
            } else if (policy.equals("no")) {
                loadcal = false;
            } else if (policy.equals("ask")) {
                msg = msg + "\n" + I18n.tr((String)"(set  \"{0}\"  to yes/no/ask in the preferences\nto control the autoloading of calibration files)", (Object[])new Object[]{prefkey});
                int answer = JOptionPane.showConfirmDialog(Main.parent, msg = msg + "\n" + I18n.tr((String)"Do you want to apply it ?"), I18n.tr((String)"Load calibration file ?"), 0);
                if (answer == 0) {
                    loadcal = true;
                }
            } else {
                msg = msg + "\n" + I18n.tr((String)"It will be applied automatically.");
                msg = msg + "\n" + I18n.tr((String)"Also, frow now on, cal files will always be loaded automatically.");
                msg = msg + "\n" + I18n.tr((String)"Set  \"{0}\"  to yes/no/ask in the preferences\nto control the autoloading of calibration files.", (Object[])new Object[]{prefkey});
                JOptionPane.showMessageDialog(Main.parent, msg, "Automatic loading of the calibration", 1);
                Main.pref.put(prefkey, "yes");
                loadcal = true;
            }
            if (loadcal) {
                this.loadCalibration(calFile);
            }
        }
        return image;
    }

    protected String getPicLayerName() {
        return this.m_tooltiptext;
    }
}

