/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.piclayer.CalibrationFileFilter;
import org.openstreetmap.josm.plugins.piclayer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;

public class LoadPictureCalibrationAction
extends JosmAction {
    PicLayerAbstract m_owner = null;
    JFileChooser m_filechooser = null;

    public LoadPictureCalibrationAction(PicLayerAbstract owner) {
        super(I18n.tr((String)"Load Picture Calibration..."), null, I18n.tr((String)"Loads calibration data from a file"), null, false);
        this.m_owner = owner;
    }

    public void actionPerformed(ActionEvent arg0) {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new CalibrationFileFilter());
        fc.setSelectedFile(new File(this.m_owner.getPicLayerName() + ".cal"));
        int result = fc.showOpenDialog(Main.parent);
        if (result == 0) {
            try {
                this.m_owner.loadCalibration(fc.getSelectedFile());
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Loading file failed: {0}", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }
}

