/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.ui;

import java.awt.Component;
import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ScriptEngineCellRenderer
implements ListCellRenderer {
    private final JLabel lbl = new JLabel();

    protected String getDisplayName(ScriptEngineFactory factory) {
        return I18n.tr((String)"{1} (with engine {0})", (Object[])new Object[]{factory.getEngineName(), factory.getLanguageName()});
    }

    protected String getTooltipText(ScriptEngineFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<strong>").append(I18n.tr((String)"Name:")).append("</strong> ").append(factory.getEngineName()).append("<br>");
        sb.append("<strong>").append(I18n.tr((String)"Version:")).append("</strong> ").append(factory.getEngineVersion()).append("<br>");
        sb.append("<strong>").append(I18n.tr((String)"Language:")).append("</strong> ").append(factory.getLanguageName()).append("<br>");
        sb.append("<strong>").append(I18n.tr((String)"Language version:")).append("</strong> ").append(factory.getLanguageVersion()).append("<br>");
        sb.append("<strong>").append(I18n.tr((String)"MIME-Types:")).append("</strong> ");
        List<String> types = factory.getMimeTypes();
        for (int i = 0; i < types.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(types.get(i));
        }
        sb.append("<br>");
        sb.append("</html>");
        return sb.toString();
    }

    protected void renderColors(boolean selected) {
        if (!selected) {
            this.lbl.setForeground(UIManager.getColor("List.foreground"));
            this.lbl.setBackground(UIManager.getColor("List.background"));
        } else {
            this.lbl.setForeground(UIManager.getColor("List.selectionForeground"));
            this.lbl.setBackground(UIManager.getColor("List.selectionBackground"));
        }
    }

    public ScriptEngineCellRenderer() {
        this.lbl.setOpaque(true);
        this.lbl.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.lbl.setIcon(ImageProvider.get((String)"script-engine"));
    }

    public Component getListCellRendererComponent(JList list, Object obj, int index, boolean isSelected, boolean cellHasFocus) {
        ScriptEngineFactory factory = (ScriptEngineFactory)obj;
        this.renderColors(isSelected);
        this.lbl.setText(this.getDisplayName(factory));
        this.lbl.setToolTipText(this.getTooltipText(factory));
        return this.lbl;
    }
}

