/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.preferences;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.openstreetmap.josm.tools.I18n;

public class ScriptEngineJarInfo
implements Comparable<ScriptEngineJarInfo> {
    public static final String OK_MESSAGE = "OK";
    private String jarFileName;
    private String statusMessage = null;

    public void analyse() {
        File jar = null;
        jar = new File(this.jarFileName);
        if (!jar.exists()) {
            this.statusMessage = I18n.tr((String)"''{0}'' doesn''t exist.", (Object[])new Object[]{jar});
            return;
        }
        if (!jar.isFile()) {
            System.out.println("jar=" + jar);
            this.statusMessage = I18n.tr((String)"''{0}'' is a directory. Expecting a jar file instead.", (Object[])new Object[]{jar});
            return;
        }
        if (!jar.canRead()) {
            this.statusMessage = I18n.tr((String)"''{0}'' isn't readable. Can''t load a script engine from this file.", (Object[])new Object[]{jar});
            return;
        }
        JarFile jf = null;
        try {
            jf = new JarFile(jar);
        }
        catch (IOException e) {
            this.statusMessage = I18n.tr((String)"Failed to open file ''{0}'' as jar file. Can''t load a script engine from this file", (Object[])new Object[]{jar});
            return;
        }
        ZipEntry ze = jf.getEntry("META-INF/services/javax.script.ScriptEngineFactory");
        if (ze == null) {
            this.statusMessage = I18n.tr((String)"The jar file ''{0}'' doesn''t provide a script engine. The entry ''{1}'' is missing.", (Object[])new Object[]{jar, "/META-INF/services/javax.script.ScriptEngineFactory"});
            return;
        }
        this.statusMessage = OK_MESSAGE;
    }

    public ScriptEngineJarInfo(String fileName) {
        if (fileName == null) {
            fileName = "";
        }
        this.jarFileName = fileName.trim();
        this.analyse();
    }

    public String getStatusMessage() {
        if (this.statusMessage == null) {
            this.analyse();
        }
        return this.statusMessage;
    }

    public String getJarFilePath() {
        return this.jarFileName;
    }

    public void setJarFilePath(String path) {
        if (path == null) {
            path = "";
        }
        this.jarFileName = path = path.trim();
        this.analyse();
    }

    public String toString() {
        return MessageFormat.format("<scriptJarInfo for=''{0}'' />", this.jarFileName);
    }

    @Override
    public int compareTo(ScriptEngineJarInfo o) {
        if (o == null) {
            return -1;
        }
        return this.jarFileName.compareTo(o.jarFileName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jarFileName == null ? 0 : this.jarFileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptEngineJarInfo other = (ScriptEngineJarInfo)obj;
        return !(this.jarFileName == null ? other.jarFileName != null : !this.jarFileName.equals(other.jarFileName));
    }
}

