/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.activation.MimetypesFileTypeMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractListModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.scripting.ScriptingPlugin;
import org.openstreetmap.josm.plugins.scripting.preferences.PreferenceKeys;
import org.openstreetmap.josm.plugins.scripting.preferences.ScriptEngineJarInfo;
import org.openstreetmap.josm.tools.I18n;

public class ScriptEngineProvider
extends AbstractListModel
implements PreferenceKeys {
    private static final Logger logger = Logger.getLogger(ScriptEngineProvider.class.getName());
    private static ScriptEngineProvider instance;
    private final List<ScriptEngineFactory> factories = new ArrayList<ScriptEngineFactory>();
    private final List<File> scriptEngineJars = new ArrayList<File>();
    private MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
    private ClassLoader scriptClassLoader = this.getClass().getClassLoader();

    public static ScriptEngineProvider getInstance() {
        if (instance == null) {
            instance = new ScriptEngineProvider();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMimeTypesMap() {
        File f = new File(ScriptingPlugin.getInstance().getPluginDir(), "mime.types");
        if (f.isFile() && f.canRead()) {
            try {
                this.mimeTypesMap = new MimetypesFileTypeMap((InputStream)new FileInputStream(f));
                return;
            }
            catch (IOException e) {
                System.err.println(I18n.tr((String)"Warning: failed to load mime types from file ''0''.", (Object[])new Object[]{f}));
                e.printStackTrace();
            }
        }
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/resources/mime.types.default");
            if (is == null) {
                System.err.println(I18n.tr((String)"Warning: failed to load default mime types from  resource ''0''.", (Object[])new Object[]{"/resources/mime.types.default"}));
                return;
            }
            this.mimeTypesMap = new MimetypesFileTypeMap(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void restoreScriptEngineUrlsFromPreferences() {
        this.scriptEngineJars.clear();
        Collection jars = Main.pref.getCollection("scripting.engine-jars", null);
        if (jars == null) {
            return;
        }
        for (String jar : jars) {
            ScriptEngineJarInfo info;
            if ((jar = jar.trim()).isEmpty() || !(info = new ScriptEngineJarInfo(jar)).getStatusMessage().equals("OK")) continue;
            this.scriptEngineJars.add(new File(jar));
        }
        this.scriptClassLoader = this.buildClassLoader();
    }

    protected ClassLoader buildClassLoader() {
        Object cl = null;
        URL[] urls = new URL[this.scriptEngineJars.size()];
        for (int i = 0; i < this.scriptEngineJars.size(); ++i) {
            try {
                urls[i] = this.scriptEngineJars.get(i).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        if (urls.length > 0) {
            return new URLClassLoader(urls, this.getClass().getClassLoader());
        }
        return this.getClass().getClassLoader();
    }

    protected void loadScriptEngineFactories() {
        try {
            ClassLoader cl = this.buildClassLoader();
            this.factories.clear();
            ScriptEngineManager manager = new ScriptEngineManager(cl);
            this.factories.addAll(manager.getEngineFactories());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        Collections.sort(this.factories, new Comparator<ScriptEngineFactory>(){

            @Override
            public int compare(ScriptEngineFactory f1, ScriptEngineFactory f2) {
                return f1.getEngineName().compareTo(f2.getEngineName());
            }
        });
    }

    private ScriptEngineProvider() {
        this.restoreScriptEngineUrlsFromPreferences();
        this.loadScriptEngineFactories();
        this.loadMimeTypesMap();
        this.fireContentsChanged(this, 0, this.scriptEngineJars.size());
    }

    public List<File> getScriptEngineJars() {
        return new ArrayList<File>(this.scriptEngineJars);
    }

    public ScriptEngine getEngineByName(String name) {
        ScriptEngineManager mgr = new ScriptEngineManager(this.scriptClassLoader);
        return mgr.getEngineByName(name);
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        ScriptEngineManager mgr = new ScriptEngineManager(this.buildClassLoader());
        return mgr.getEngineByMimeType(mimeType);
    }

    public ScriptEngine getEngineForFile(File scriptFile) {
        if (scriptFile == null) {
            return null;
        }
        ScriptEngineManager mgr = new ScriptEngineManager(this.buildClassLoader());
        return mgr.getEngineByMimeType(this.mimeTypesMap.getContentType(scriptFile));
    }

    public void setScriptEngineJars(List<File> jars) {
        this.scriptEngineJars.clear();
        if (jars != null) {
            for (File jar : jars) {
                ScriptEngineJarInfo info;
                if (jar == null || !(info = new ScriptEngineJarInfo(jar.toString())).getStatusMessage().equals("OK")) continue;
                this.scriptEngineJars.add(jar);
            }
        }
        this.buildClassLoader();
        this.loadScriptEngineFactories();
        this.fireContentsChanged(this, 0, this.scriptEngineJars.size());
    }

    public ScriptEngine getScriptEngine(int i) {
        ScriptEngine engine = this.factories.get(i).getScriptEngine();
        return engine;
    }

    @Override
    public Object getElementAt(int i) {
        return this.factories.get(i);
    }

    @Override
    public int getSize() {
        return this.factories.size();
    }
}

