/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.plugins.scripting.CompiledScriptCache;
import org.openstreetmap.josm.plugins.scripting.ScriptEngineProvider;
import org.openstreetmap.josm.plugins.scripting.ScriptEngineSelectionDialog;
import org.openstreetmap.josm.plugins.scripting.preferences.PreferenceKeys;
import org.openstreetmap.josm.plugins.scripting.util.IOUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class RunScriptDialog
extends JDialog
implements PreferenceKeys {
    private static final Logger logger = Logger.getLogger(RunScriptDialog.class.getName());
    private HistoryComboBox cbScriptFile;
    private Action actRun;

    public RunScriptDialog(Component parent) {
        super((Window)JOptionPane.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
        HelpUtil.setHelpContext((JComponent)this.getRootPane(), (String)HelpUtil.ht((String)"/Plugin/Scripting"));
    }

    protected JPanel buildInfoPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        HtmlPanel info = new HtmlPanel();
        info.setText("<html>" + I18n.tr((String)"Select a script file and click on <strong>Run</strong>.") + "</html>");
        pnl.add((Component)info, "Center");
        return pnl;
    }

    protected JPanel buildControlButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        this.actRun = new RunAction();
        SideButton btn = new SideButton(this.actRun);
        pnl.add((Component)btn);
        btn.setFocusable(true);
        btn.registerKeyboardAction(this.actRun, KeyStroke.getKeyStroke("ENTER"), 0);
        pnl.add((Component)new SideButton((Action)new CancelAction()));
        pnl.add((Component)new SideButton((Action)new ContextSensitiveHelpAction(HelpUtil.ht((String)"/Plugin/Scripting#Run"))));
        return pnl;
    }

    protected JPanel buildMacroFileInputPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(3, 3, 3, 3);
        gc.fill = 1;
        pnl.add((Component)new JLabel(I18n.tr((String)"File:")), gc);
        this.cbScriptFile = new HistoryComboBox();
        SelectAllOnFocusGainedDecorator.decorate((JTextComponent)((JTextField)this.cbScriptFile.getEditor().getEditorComponent()));
        this.cbScriptFile.setToolTipText(I18n.tr((String)"Enter the name of a script file"));
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(3, 3, 3, 0);
        gc.fill = 1;
        pnl.add((Component)this.cbScriptFile, gc);
        gc.gridx = 2;
        gc.weightx = 0.0;
        gc.fill = 1;
        gc.insets = new Insets(3, 0, 3, 3);
        JButton btn = new JButton(new SelectMacroFileAction());
        pnl.add((Component)btn, gc);
        btn.setFocusable(false);
        JPanel filler = new JPanel();
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 3;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        pnl.add((Component)filler, gc);
        return pnl;
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.buildInfoPanel(), "North");
        pnl.add((Component)this.buildMacroFileInputPanel(), "Center");
        pnl.add((Component)this.buildControlButtonPanel(), "South");
        return pnl;
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildContentPanel(), "Center");
        this.getRootPane().registerKeyboardAction(this.actRun, KeyStroke.getKeyStroke("ctrl ENTER"), 1);
        this.setTitle(I18n.tr((String)"Run a script"));
        this.setSize(600, 150);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                RunScriptDialog.this.cbScriptFile.requestFocusInWindow();
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            LinkedList fileHistory = new LinkedList(Main.pref.getCollection("scripting.RunScriptDialog.file-history", new LinkedList()));
            Collections.reverse(fileHistory);
            this.cbScriptFile.setPossibleItems(fileHistory);
            String lastFile = Main.pref.get("scripting.RunScriptDialog.last-file");
            if (lastFile != null && !lastFile.trim().isEmpty()) {
                this.cbScriptFile.setText(lastFile.trim());
            }
            WindowGeometry.centerInWindow((Component)this.getParent(), (Dimension)new Dimension(600, 150)).applySafe((Window)this);
        } else {
            String currentFile = this.cbScriptFile.getText();
            Main.pref.put("scripting.RunScriptDialog.last-file", currentFile.trim());
            Main.pref.putCollection("scripting.RunScriptDialog.file-history", (Collection)this.cbScriptFile.getHistory());
        }
        super.setVisible(visible);
    }

    private class SelectMacroFileAction
    extends AbstractAction {
        public SelectMacroFileAction() {
            this.putValue("Name", I18n.tr((String)"..."));
            this.putValue("ShortDescription", I18n.tr((String)"Launch file selection dialog"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int ret;
            String fileName = RunScriptDialog.this.cbScriptFile.getText().trim();
            File currentFile = null;
            if (!fileName.isEmpty()) {
                currentFile = new File(fileName);
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(I18n.tr((String)"Select a script"));
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            if (currentFile != null) {
                chooser.setCurrentDirectory(currentFile);
                chooser.setSelectedFile(currentFile);
            }
            if ((ret = chooser.showOpenDialog(RunScriptDialog.this)) != 0) {
                return;
            }
            currentFile = chooser.getSelectedFile();
            RunScriptDialog.this.cbScriptFile.setText(currentFile.toString());
        }
    }

    private class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("Name", I18n.tr((String)"Run"));
            this.putValue("ShortDescription", I18n.tr((String)"Run the script"));
            this.putValue("SmallIcon", ImageProvider.get((String)"run"));
        }

        protected void warnMacroFileDoesntExist(File f) {
            HelpAwareOptionPane.showOptionDialog(null, (Object)I18n.tr((String)"The script file ''{0}'' doesn''t exist.", (Object[])new Object[]{f.toString()}), (String)I18n.tr((String)"File not found"), (int)0, (String)HelpUtil.ht((String)"/Plugin/Scripting"));
        }

        protected void warnEmptyFile() {
            HelpAwareOptionPane.showOptionDialog((Component)RunScriptDialog.this.cbScriptFile, (Object)I18n.tr((String)"Please enter a file name first."), (String)I18n.tr((String)"Empty file name"), (int)0, (String)HelpUtil.ht((String)"/Plugin/Scripting"));
        }

        protected void warnMacroFileIsntReadable(File f) {
            HelpAwareOptionPane.showOptionDialog((Component)RunScriptDialog.this, (Object)I18n.tr((String)"The script file ''{0}'' isn''t readable.", (Object[])new Object[]{f.toString()}), (String)I18n.tr((String)"File not readable"), (int)0, (String)HelpUtil.ht((String)"/Plugin/Scripting"));
        }

        protected void warnFailedToOpenMacroFile(File f, Exception e) {
            HelpAwareOptionPane.showOptionDialog((Component)RunScriptDialog.this, (Object)I18n.tr((String)"Failed to read the script from the file ''{0}''.", (Object[])new Object[]{f.toString()}), (String)I18n.tr((String)"IO error"), (int)0, (String)HelpUtil.ht((String)"/Plugin/Scripting"));
            System.out.println(I18n.tr((String)"Failed to read a macro from the file ''{0}''.", (Object[])new Object[]{f.toString()}));
            e.printStackTrace();
        }

        protected void warnExecutingScriptFailed(ScriptException e) {
            HelpAwareOptionPane.showOptionDialog((Component)RunScriptDialog.this, (Object)I18n.tr((String)"Script execution has failed."), (String)I18n.tr((String)"Script Error"), (int)0, (String)HelpUtil.ht((String)"/Plugin/Scripting"));
            System.out.println(I18n.tr((String)"Macro execution has failed."));
            e.printStackTrace();
        }

        protected void warnNoScriptingEnginesInstalled() {
            HelpAwareOptionPane.showOptionDialog((Component)RunScriptDialog.this, (Object)("<html>" + I18n.tr((String)"<p>The script can''t be executed, because there are currently no scripting engines installed.</p><p>Refer to the online help for information about how to install a scripting engine with JOSM.</p>") + "</html>"), (String)I18n.tr((String)"No script engine"), (int)0, (String)HelpUtil.ht((String)"/Plugin/Scripting"));
        }

        protected ScriptEngine getScriptEngine(File file) {
            ScriptEngine engine = ScriptEngineProvider.getInstance().getEngineForFile(file);
            if (engine != null) {
                return engine;
            }
            return ScriptEngineSelectionDialog.select(RunScriptDialog.this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String fileName = RunScriptDialog.this.cbScriptFile.getText().trim();
            if (fileName.isEmpty()) {
                this.warnEmptyFile();
                return;
            }
            final File f = new File(fileName);
            if (!f.exists() || !f.isFile()) {
                this.warnMacroFileDoesntExist(f);
                return;
            }
            if (!f.canRead()) {
                this.warnMacroFileIsntReadable(f);
                return;
            }
            RunScriptDialog.this.cbScriptFile.addCurrentItemToHistory();
            try {
                new FileReader(f);
            }
            catch (IOException e) {
                this.warnFailedToOpenMacroFile(f, e);
                return;
            }
            final ScriptEngine engine = this.getScriptEngine(f);
            if (engine == null) {
                return;
            }
            RunScriptDialog.this.setVisible(false);
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    FileReader reader = null;
                    try {
                        if (engine instanceof Compilable) {
                            CompiledScript script = CompiledScriptCache.getInstance().compile((Compilable)((Object)engine), f);
                            script.eval();
                        } else {
                            reader = new FileReader(f);
                            engine.eval(reader);
                        }
                        IOUtil.close(reader);
                    }
                    catch (ScriptException e) {
                        RunAction.this.warnExecutingScriptFailed(e);
                    }
                    catch (IOException e2) {
                        RunAction.this.warnFailedToOpenMacroFile(f, e2);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        IOUtil.close(reader);
                    }
                    finally {
                        IOUtil.close(reader);
                    }
                }
            });
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr((String)"Cancel"));
            this.putValue("ShortDescription", I18n.tr((String)"Cancel"));
            this.putValue("SmallIcon", ImageProvider.get((String)"cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            RunScriptDialog.this.setVisible(false);
        }
    }
}

