/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import org.openstreetmap.josm.plugins.scripting.util.Assert;
import org.openstreetmap.josm.plugins.scripting.util.IOUtil;

public class CompiledScriptCache {
    private static final Logger logger = Logger.getLogger(CompiledScriptCache.class.getName());
    private static final CompiledScriptCache instance = new CompiledScriptCache();
    private final Map<File, CacheEntry> cache = new HashMap<File, CacheEntry>();

    public static CompiledScriptCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledScript compile(Compilable compiler, File scriptFile) throws ScriptException, IOException, IllegalArgumentException {
        CompiledScript compiledScript;
        Assert.assertArgNotNull(scriptFile, "scriptFile");
        Assert.assertArgNotNull(compiler, "compiler");
        CacheEntry entry = this.cache.get(scriptFile);
        if (entry != null && entry.getTimestamp() >= scriptFile.lastModified()) {
            return entry.getScript();
        }
        FileReader reader = null;
        try {
            reader = new FileReader(scriptFile);
            CompiledScript script = compiler.compile(reader);
            entry = new CacheEntry(scriptFile, script);
            this.cache.put(scriptFile, entry);
            compiledScript = script;
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close(reader);
        return compiledScript;
    }

    private static class CacheEntry {
        private File file;
        private CompiledScript script;
        private long timestamp;

        public CacheEntry(File file, CompiledScript script) {
            this.timestamp = file.lastModified();
            this.file = file;
            this.script = script;
        }

        public File getFile() {
            return this.file;
        }

        public CompiledScript getScript() {
            return this.script;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

