/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Address
extends MapMode
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private String tagHighway = "highway";
    private String tagHighwayName = "name";
    private String tagHouseNumber = "addr:housenumber";
    private String tagHouseStreet = "addr:street";
    private String tagBuilding = "building";
    private String relationAddrType = "associatedStreet";
    private String relationAddrName = "name";
    private String relationAddrStreetRole = "street";
    private String relationMemberHouse = "house";
    private JRadioButton plus_one = new JRadioButton("+1", false);
    private JRadioButton plus_two = new JRadioButton("+2", true);
    private JRadioButton minus_one = new JRadioButton("-1", false);
    private JRadioButton minus_two = new JRadioButton("-2", false);
    final JCheckBox tagPolygon = new JCheckBox(I18n.tr((String)"on polygon"));
    JDialog dialog = null;
    JButton clearButton = null;
    final JTextField inputNumber = new JTextField();
    final JTextField inputStreet = new JTextField();
    JLabel link = new JLabel();
    private Way selectedWay;
    private boolean shift;
    private boolean ctrl;

    public Address(MapFrame mapFrame) {
        super(I18n.tr((String)"Add address"), "buildings", I18n.tr((String)"Helping tool for tag address"), Shortcut.registerShortcut((String)"mapmode:buildings", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Buildings")}), (int)69, (int)3), mapFrame, Address.getCursor());
    }

    public void enterMode() {
        super.enterMode();
        if (this.dialog == null) {
            this.createDialog();
        }
        this.dialog.setVisible(true);
        Main.map.mapView.addMouseListener((MouseListener)this);
    }

    public void exitMode() {
        if (Main.map.mapView != null) {
            super.exitMode();
            Main.map.mapView.removeMouseListener((MouseListener)this);
        }
        this.dialog.setVisible(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.shift = (e.getModifiers() & 1) != 0;
        this.ctrl = (e.getModifiers() & 2) != 0;
        MapView mv = Main.map.mapView;
        Point mousePos = e.getPoint();
        ArrayList<Way> mouseOnExistingWays = new ArrayList<Way>();
        ArrayList<Way> mouseOnExistingBuildingWays = new ArrayList<Way>();
        mouseOnExistingWays = new ArrayList();
        Node currentMouseNode = mv.getNearestNode(mousePos, OsmPrimitive.isSelectablePredicate);
        if (currentMouseNode != null) {
            this.setNewSelection((OsmPrimitive)currentMouseNode);
            String num = currentMouseNode.get(this.tagHouseNumber);
            if (num != null && currentMouseNode.get(this.tagHouseStreet) == null && this.findWayInRelationAddr(currentMouseNode) == null && !this.inputStreet.getText().equals("")) {
                LinkedList<Command> cmds = new LinkedList<Command>();
                this.addStreetNameOrRelation((OsmPrimitive)currentMouseNode, cmds);
                SequenceCommand c = new SequenceCommand("Add node address", cmds);
                Main.main.undoRedo.add((Command)c);
                this.setNewSelection((OsmPrimitive)currentMouseNode);
            } else {
                if (num != null) {
                    try {
                        Integer.parseInt(num);
                        this.inputNumber.setText(num);
                        this.applyInputNumberChange();
                    }
                    catch (NumberFormatException en) {
                        System.out.println("Unable to parse house number \"" + num + "\"");
                    }
                }
                if (currentMouseNode.get(this.tagHouseStreet) != null) {
                    this.inputStreet.setText(currentMouseNode.get(this.tagHouseStreet));
                    if (this.ctrl) {
                        LinkedList<Command> cmds = new LinkedList<Command>();
                        this.addAddrToPrimitive((OsmPrimitive)currentMouseNode, cmds);
                        if (num == null) {
                            this.applyInputNumberChange();
                        }
                    }
                    this.setSelectedWay(null);
                } else {
                    Way wayInRelationAddr = this.findWayInRelationAddr(currentMouseNode);
                    if (wayInRelationAddr == null) {
                        if (this.ctrl) {
                            this.applyInputNumberChange();
                        }
                        LinkedList<Command> cmds = new LinkedList<Command>();
                        this.addAddrToPrimitive((OsmPrimitive)currentMouseNode, cmds);
                    } else {
                        this.inputStreet.setText(wayInRelationAddr.get(this.tagHighwayName));
                        this.setSelectedWay(wayInRelationAddr);
                    }
                }
            }
        } else {
            List wss = mv.getNearestWaySegments(mousePos, OsmPrimitive.isSelectablePredicate);
            for (WaySegment ws : wss) {
                if (ws.way.get(this.tagHighway) != null && ws.way.get(this.tagHighwayName) != null) {
                    mouseOnExistingWays.add(ws.way);
                    continue;
                }
                if (ws.way.get(this.tagBuilding) == null || ws.way.get(this.tagHouseNumber) != null) continue;
                mouseOnExistingBuildingWays.add(ws.way);
            }
            if (mouseOnExistingWays.size() == 1) {
                this.inputStreet.setText(((Way)mouseOnExistingWays.get(0)).get(this.tagHighwayName));
                this.setSelectedWay((Way)mouseOnExistingWays.get(0));
                this.inputNumber.setText("");
                this.setNewSelection((OsmPrimitive)mouseOnExistingWays.get(0));
            } else if (mouseOnExistingWays.size() == 0) {
                if (this.inputStreet.getText().equals("") || this.inputNumber.getText().equals("")) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    LinkedList<Command> cmds = new LinkedList<Command>();
                    if (this.ctrl) {
                        this.applyInputNumberChange();
                    }
                    if (this.tagPolygon.isSelected()) {
                        this.addAddrToPolygon(mouseOnExistingBuildingWays, cmds);
                    } else {
                        Node n = this.createNewNode(e, cmds);
                        this.addAddrToPrimitive((OsmPrimitive)n, cmds);
                    }
                }
            }
        }
    }

    private Way findWayInRelationAddr(Node n) {
        List l = n.getReferrers();
        for (OsmPrimitive osm : l) {
            if (!(osm instanceof Relation) || !osm.hasKey("type") || !osm.get("type").equals(this.relationAddrType)) continue;
            for (RelationMember rm : ((Relation)osm).getMembers()) {
                OsmPrimitive osp;
                if (!rm.getRole().equals(this.relationAddrStreetRole) || !((osp = rm.getMember()) instanceof Way) || !osp.hasKey(this.tagHighwayName)) continue;
                return (Way)osp;
            }
        }
        return null;
    }

    private void addAddrToPolygon(List<Way> mouseOnExistingBuildingWays, Collection<Command> cmds) {
        for (Way w : mouseOnExistingBuildingWays) {
            this.addAddrToPrimitive((OsmPrimitive)w, cmds);
        }
    }

    private void addAddrToPrimitive(OsmPrimitive osm, Collection<Command> cmds) {
        if (this.shift) {
            try {
                this.revertInputNumberChange();
            }
            catch (NumberFormatException en) {
                System.out.println("Unable to parse house number \"" + this.inputNumber.getText() + "\"");
            }
        }
        cmds.add((Command)new ChangePropertyCommand(osm, this.tagHouseNumber, this.inputNumber.getText()));
        this.addStreetNameOrRelation(osm, cmds);
        try {
            this.applyInputNumberChange();
            SequenceCommand c = new SequenceCommand("Add node address", cmds);
            Main.main.undoRedo.add((Command)c);
            this.setNewSelection(osm);
        }
        catch (NumberFormatException en) {
            System.out.println("Unable to parse house number \"" + this.inputNumber.getText() + "\"");
        }
    }

    private Relation findRelationAddr(Way w) {
        List l = w.getReferrers();
        for (OsmPrimitive osm : l) {
            if (!(osm instanceof Relation) || !osm.hasKey("type") || !osm.get("type").equals(this.relationAddrType)) continue;
            return (Relation)osm;
        }
        return null;
    }

    private void addStreetNameOrRelation(OsmPrimitive osm, Collection<Command> cmds) {
        if (Main.pref.getBoolean("cadastrewms.addr.dontUseRelation", false)) {
            cmds.add((Command)new ChangePropertyCommand(osm, this.tagHouseStreet, this.inputStreet.getText()));
        } else if (this.selectedWay != null) {
            Relation selectedRelation = this.findRelationAddr(this.selectedWay);
            if (selectedRelation != null) {
                RelationMember rm = new RelationMember(this.relationMemberHouse, osm);
                Relation newRel = new Relation(selectedRelation);
                newRel.addMember(rm);
                cmds.add((Command)new ChangeCommand((OsmPrimitive)selectedRelation, (OsmPrimitive)newRel));
            } else {
                Relation newRel = new Relation();
                newRel.put("type", this.relationAddrType);
                newRel.put(this.relationAddrName, this.selectedWay.get(this.tagHighwayName));
                newRel.addMember(new RelationMember(this.relationAddrStreetRole, (OsmPrimitive)this.selectedWay));
                newRel.addMember(new RelationMember(this.relationMemberHouse, osm));
                cmds.add((Command)new AddCommand((OsmPrimitive)newRel));
            }
        }
    }

    private Node createNewNode(MouseEvent e, Collection<Command> cmds) {
        Node n = new Node(Main.map.mapView.getLatLon(e.getX(), e.getY()));
        cmds.add((Command)new AddCommand((OsmPrimitive)n));
        List wss = Main.map.mapView.getNearestWaySegments(e.getPoint(), OsmPrimitive.isSelectablePredicate);
        HashMap insertPoints = new HashMap();
        for (WaySegment ws : wss) {
            List<Integer> is;
            if (insertPoints.containsKey(ws.way)) {
                is = (List)insertPoints.get(ws.way);
            } else {
                is = new ArrayList();
                insertPoints.put(ws.way, is);
            }
            is.add(ws.lowerIndex);
        }
        HashSet<Pair<Node, Node>> segSet = new HashSet<Pair<Node, Node>>();
        ArrayList replacedWays = new ArrayList();
        ArrayList<Way> reuseWays = new ArrayList<Way>();
        for (Map.Entry insertPoint : insertPoints.entrySet()) {
            int i;
            Way w = (Way)insertPoint.getKey();
            List is = (List)insertPoint.getValue();
            Way wnew = new Way(w);
            Address.pruneSuccsAndReverse(is);
            Iterator i$ = is.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                segSet.add((Pair<Node, Node>)Pair.sort((Pair)new Pair((Object)w.getNode(i), (Object)w.getNode(i + 1))));
            }
            i$ = is.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                wnew.addNode(i + 1, n);
            }
            cmds.add((Command)new ChangeCommand((OsmPrimitive)insertPoint.getKey(), (OsmPrimitive)wnew));
            replacedWays.add(insertPoint.getKey());
            reuseWays.add(wnew);
        }
        Address.adjustNode(segSet, n);
        return n;
    }

    private static void adjustNode(Collection<Pair<Node, Node>> segs, Node n) {
        double q;
        EastNorth B;
        EastNorth A;
        Pair<Node, Node> seg;
        switch (segs.size()) {
            case 0: {
                return;
            }
            case 2: {
                Iterator<Pair<Node, Node>> i = segs.iterator();
                seg = i.next();
                A = ((Node)seg.a).getEastNorth();
                B = ((Node)seg.b).getEastNorth();
                seg = i.next();
                EastNorth C = ((Node)seg.a).getEastNorth();
                EastNorth D = ((Node)seg.b).getEastNorth();
                double u = Address.det(B.east() - A.east(), B.north() - A.north(), C.east() - D.east(), C.north() - D.north());
                if (u == 0.0) {
                    return;
                }
                q = Address.det(B.north() - C.north(), B.east() - C.east(), D.north() - C.north(), D.east() - C.east()) / u;
                EastNorth intersection = new EastNorth(B.east() + q * (A.east() - B.east()), B.north() + q * (A.north() - B.north()));
                int snapToIntersectionThreshold = Main.pref.getInteger("edit.snap-intersection-threshold", 10);
                if (!(Main.map.mapView.getPoint(n).distance(Main.map.mapView.getPoint(intersection)) < (double)snapToIntersectionThreshold)) break;
                n.setEastNorth(intersection);
                return;
            }
        }
        EastNorth P = n.getEastNorth();
        seg = segs.iterator().next();
        A = ((Node)seg.a).getEastNorth();
        B = ((Node)seg.b).getEastNorth();
        double a = P.distanceSq((Point2D)B);
        double b = P.distanceSq((Point2D)A);
        double c = A.distanceSq((Point2D)B);
        q = (a - b + c) / (2.0 * c);
        n.setEastNorth(new EastNorth(B.east() + q * (A.east() - B.east()), B.north() + q * (A.north() - B.north())));
    }

    static double det(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    private static void pruneSuccsAndReverse(List<Integer> is) {
        HashSet<Integer> is2 = new HashSet<Integer>();
        for (int i : is) {
            if (is2.contains(i - 1) || is2.contains(i + 1)) continue;
            is2.add(i);
        }
        is.clear();
        is.addAll(is2);
        Collections.sort(is);
        Collections.reverse(is);
    }

    private static Cursor getCursor() {
        try {
            return ImageProvider.getCursor((String)"crosshair", null);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(1);
        }
    }

    private void applyInputNumberChange() {
        Integer num = Integer.parseInt(this.inputNumber.getText());
        if (this.plus_one.isSelected()) {
            num = num + 1;
        }
        if (this.plus_two.isSelected()) {
            num = num + 2;
        }
        if (this.minus_one.isSelected() && num > 1) {
            num = num - 1;
        }
        if (this.minus_two.isSelected() && num > 2) {
            num = num - 2;
        }
        this.inputNumber.setText(num.toString());
    }

    private void revertInputNumberChange() {
        Integer num = Integer.parseInt(this.inputNumber.getText());
        if (this.plus_one.isSelected()) {
            num = num - 1;
        }
        if (this.plus_two.isSelected()) {
            num = num - 2;
        }
        if (this.minus_one.isSelected() && num > 1) {
            num = num + 1;
        }
        if (this.minus_two.isSelected() && num > 2) {
            num = num + 2;
        }
        this.inputNumber.setText(num.toString());
    }

    private void createDialog() {
        ImageIcon iconLink = ImageProvider.get(null, (String)"Mf_relation.png");
        this.link.setIcon(iconLink);
        this.link.setEnabled(false);
        JPanel p = new JPanel(new GridBagLayout());
        JLabel number = new JLabel(I18n.tr((String)"Next no"));
        JLabel street = new JLabel(I18n.tr((String)"Street"));
        p.add((Component)number, GBC.std().insets(0, 0, 0, 0));
        p.add((Component)this.inputNumber, GBC.eol().fill(2).insets(5, 5, 0, 5));
        p.add((Component)street, GBC.std().insets(0, 0, 0, 0));
        JPanel p2 = new JPanel(new GridBagLayout());
        this.inputStreet.setEditable(false);
        p2.add((Component)this.inputStreet, GBC.std().fill(2).insets(5, 0, 0, 0));
        p2.add((Component)this.link, GBC.eol().insets(10, 0, 0, 0));
        p.add((Component)p2, GBC.eol().fill(2));
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Address.this.inputNumber.setText("");
                Address.this.inputStreet.setText("");
                Address.this.setSelectedWay(null);
            }
        });
        ButtonGroup bgIncremental = new ButtonGroup();
        bgIncremental.add(this.plus_one);
        bgIncremental.add(this.plus_two);
        bgIncremental.add(this.minus_one);
        bgIncremental.add(this.minus_two);
        p.add((Component)this.minus_one, GBC.std().insets(10, 0, 10, 0));
        p.add((Component)this.plus_one, GBC.std().insets(0, 0, 10, 0));
        this.tagPolygon.setSelected(Main.pref.getBoolean("cadastrewms.addr.onBuilding", false));
        this.tagPolygon.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                Main.pref.put("cadastrewms.addr.onBuilding", Address.this.tagPolygon.isSelected());
            }
        });
        p.add((Component)this.tagPolygon, GBC.eol().fill(2).insets(0, 0, 0, 0));
        p.add((Component)this.minus_two, GBC.std().insets(10, 0, 10, 0));
        p.add((Component)this.plus_two, GBC.std().insets(0, 0, 10, 0));
        p.add((Component)this.clearButton, GBC.eol().fill(2).insets(0, 0, 0, 0));
        Object[] options = new Object[]{};
        JOptionPane pane = new JOptionPane(p, -1, 1, null, options, null);
        this.dialog = pane.createDialog(Main.parent, I18n.tr((String)"Enter addresses"));
        this.dialog.setModal(false);
        this.dialog.setAlwaysOnTop(true);
        this.dialog.addComponentListener(new ComponentAdapter(){

            protected void rememberGeometry() {
                Main.pref.put("cadastrewms.addr.bounds", Address.this.dialog.getX() + "," + Address.this.dialog.getY() + "," + Address.this.dialog.getWidth() + "," + Address.this.dialog.getHeight());
            }

            public void componentMoved(ComponentEvent e) {
                this.rememberGeometry();
            }

            public void componentResized(ComponentEvent e) {
                this.rememberGeometry();
            }
        });
        this.dialog.addWindowListener(new WindowListener(){

            public void windowClosing(WindowEvent arg0) {
                Address.this.exitMode();
                Main.map.selectMapMode((MapMode)Main.map.getDefaultButtonAction());
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowActivated(WindowEvent arg0) {
            }

            public void windowDeactivated(WindowEvent arg0) {
            }

            public void windowDeiconified(WindowEvent arg0) {
            }

            public void windowIconified(WindowEvent arg0) {
            }

            public void windowOpened(WindowEvent arg0) {
            }
        });
        String bounds = Main.pref.get("cadastrewms.addr.bounds", null);
        if (bounds != null) {
            String[] b = bounds.split(",");
            this.dialog.setBounds(new Rectangle(Integer.parseInt(b[0]), Integer.parseInt(b[1]), Integer.parseInt(b[2]), Integer.parseInt(b[3])));
        }
    }

    private void setSelectedWay(Way w) {
        this.selectedWay = w;
        if (w == null) {
            this.link.setEnabled(false);
        } else {
            this.link.setEnabled(true);
        }
    }

    private void setNewSelection(OsmPrimitive osm) {
        LinkedList<OsmPrimitive> newSelection = new LinkedList<OsmPrimitive>(Main.main.getCurrentDataSet().getSelected());
        newSelection.clear();
        newSelection.add(osm);
        Address.getCurrentDataSet().setSelected(new PrimitiveId[]{osm});
    }
}

