/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.ElevationProfileBase;
import org.openstreetmap.josm.plugins.elevation.ElevationProfileLeaf;
import org.openstreetmap.josm.plugins.elevation.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.WayPointHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElevationProfileNode
extends ElevationProfileBase {
    private List<IElevationProfile> slices;

    public ElevationProfileNode(String trackName, IElevationProfile parent, List<WayPoint> wayPoints, int sliceSize) {
        super(trackName, parent, wayPoints, sliceSize);
        this.setSliceSize(sliceSize);
        this.createsSlices(wayPoints);
    }

    public int getNumberOfSlices() {
        return this.slices != null ? this.slices.size() : 0;
    }

    public void updateTrack(List<WayPoint> waypoints) {
        this.createsSlices(waypoints);
    }

    private void createsSlices(List<WayPoint> wayPoints) {
        if (wayPoints == null || this.getSliceSize() <= 0) {
            return;
        }
        if (this.slices == null) {
            this.slices = new ArrayList<IElevationProfile>();
        } else {
            this.slices.clear();
        }
        for (int i = 0; i < wayPoints.size(); i += this.getSliceSize()) {
            int to = Math.min(i + this.getSliceSize(), wayPoints.size());
            ElevationProfileLeaf ems = new ElevationProfileLeaf(this.getName(), this, wayPoints.subList(i, to));
            this.slices.add(ems);
        }
        this.setWayPoints(WayPointHelper.downsampleWayPoints(wayPoints, this.getSliceSize()), false);
    }

    @Override
    public List<IElevationProfile> getChildren() {
        return this.slices;
    }
}

