/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.czechaddress.CzechAddressPlugin;
import org.openstreetmap.josm.plugins.czechaddress.MapUtils;
import org.openstreetmap.josm.plugins.czechaddress.StatusListener;
import org.openstreetmap.josm.plugins.czechaddress.StringUtils;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithHouses;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithStreets;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.gui.ConflictResolver;
import org.openstreetmap.josm.plugins.czechaddress.gui.utils.HalfCookedComboBoxModel;
import org.openstreetmap.josm.plugins.czechaddress.gui.utils.HalfCookedListModel;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.ReasonerListener;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryDialog
extends ToggleDialog
implements SelectionChangedListener,
StatusListener,
ReasonerListener {
    private static FactoryDialog singleton = null;
    private HouseListModel houseModel = new HouseListModel();
    private StreetListModel streetModel = new StreetListModel();
    public boolean selectionListenerActivated = true;
    private JList houseList;
    private JScrollPane jScrollPane1;
    private JCheckBox keepOddityCheckBox;
    private JPanel mainPanel;
    private JButton relocateButton;
    private JComboBox streetComboBox;

    public static FactoryDialog getInstance() {
        if (singleton == null) {
            singleton = new FactoryDialog();
        }
        return singleton;
    }

    private FactoryDialog() {
        super("Tov\u00e1rna na adresy", "envelope-scrollbar.png", "Umo\u017e\u0148uje rychl\u00e9 vytv\u00e1\u0159en\u00ed adresn\u00edch bod\u016f \u201ejedn\u00edm kliknut\u00edm.\u201c", Shortcut.registerShortcut((String)"subwindow:addressfactory", (String)"P\u0159epnout: Tov\u00e1rna na adresy", (int)84, (int)4), 200);
        LayoutManager originalManager = this.getLayout();
        this.initComponents();
        this.setLayout(originalManager);
        this.add(this.mainPanel);
        CzechAddressPlugin.addStatusListener(this);
        this.streetModel.notifyAllListeners();
        this.houseModel.notifyAllListeners();
        this.streetComboBox.setModel(this.streetModel);
        this.streetComboBox.setRenderer(new StreetListRenderer());
        this.houseList.setModel(this.houseModel);
        this.houseList.setCellRenderer(new HouseListRenderer());
    }

    @Override
    public void pluginStatusChanged(int message) {
        if (message == 2) {
            this.relocateButton.setEnabled(true);
            return;
        }
        if (message == 1) {
            DataSet.selListeners.add(this);
            this.streetModel.setParent(CzechAddressPlugin.getLocation());
            this.relocateButton.setText("Zm\u011bnit m\u00edsto");
            this.streetComboBox.setEnabled(true);
            this.houseList.setEnabled(true);
            this.keepOddityCheckBox.setEnabled(true);
            return;
        }
    }

    public void setSelectedHouse(House house) {
        int i;
        for (i = 0; i < this.streetModel.getSize(); ++i) {
            if (this.streetModel.getElementAt(i) != house.getParent()) continue;
            this.streetComboBox.setSelectedIndex(i);
            this.streetComboBox.repaint();
            break;
        }
        for (i = 0; i < this.houseModel.getSize(); ++i) {
            if (this.houseModel.getHouseAt(i) != house) continue;
            this.houseList.setSelectedIndex(i);
            this.houseList.ensureIndexIsVisible(i);
            break;
        }
    }

    public House getSelectedHouse() {
        if (this.houseList.getSelectedValue() instanceof House) {
            return (House)this.houseList.getSelectedValue();
        }
        return null;
    }

    public boolean existsAvailableHouse() {
        int i;
        Reasoner r = Reasoner.getInstance();
        for (i = this.houseList.getSelectedIndex(); i < this.houseModel.getSize(); ++i) {
            if (r.translate((House)this.houseModel.getElementAt(i)) != null) continue;
            return true;
        }
        for (i = 0; i < this.houseList.getSelectedIndex(); ++i) {
            if (r.translate((House)this.houseModel.getElementAt(i)) != null) continue;
            return true;
        }
        return false;
    }

    public void selectNextUnmatchedHouse() {
        House current;
        int index = this.houseList.getSelectedIndex();
        ++index;
        while ((current = this.houseModel.getHouseAt(index)) != null && Reasoner.getInstance().translate(current) != null) {
            ++index;
        }
        if (index >= this.houseModel.getSize()) {
            index = 0;
        }
        this.houseList.setSelectedIndex(index);
        this.houseList.ensureIndexIsVisible(index);
    }

    public void selectNextUnmatchedHouseMaintainOddity() {
        if (this.getSelectedHouse().getCO() == null) {
            this.selectNextUnmatchedHouse();
            return;
        }
        String oldStr = StringUtils.extractNumber(this.getSelectedHouse().getCO());
        try {
            String newStr;
            int oldNum = -1;
            int newNum = -1;
            do {
                this.selectNextUnmatchedHouse();
                newStr = StringUtils.extractNumber(this.getSelectedHouse().getCO());
                if (oldNum != -1) continue;
                oldNum = Integer.valueOf(oldStr);
            } while ((oldNum + (newNum = Integer.valueOf(newStr).intValue())) % 2 == 1 && this.houseList.getSelectedIndex() != 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void selectNextUnmatchedHouseByCheckBox() {
        if (this.keepOddityCheckBox.isSelected()) {
            this.selectNextUnmatchedHouseMaintainOddity();
        } else {
            this.selectNextUnmatchedHouse();
        }
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (!this.selectionListenerActivated) {
            return;
        }
        if (newSelection.size() != 1) {
            return;
        }
        OsmPrimitive selectedPrim = (OsmPrimitive)newSelection.toArray()[0];
        String streetName = selectedPrim.get("addr:street");
        if (streetName == null) {
            if (selectedPrim.get("highway") == null) {
                return;
            }
            streetName = selectedPrim.get("name");
            if (streetName == null) {
                return;
            }
        }
        Street selectedStreet = null;
        for (Street street : CzechAddressPlugin.getLocation().getStreets()) {
            if (!street.getName().toUpperCase().equals(streetName.toUpperCase())) continue;
            selectedStreet = street;
            break;
        }
        if (selectedStreet == null) {
            return;
        }
        this.streetComboBox.setSelectedItem(selectedStreet);
        this.streetModel.notifyAllListeners();
        int bestQuality = -5;
        House bestHouse = null;
        for (House currHouse : selectedStreet.getHouses()) {
            int currQuality = currHouse.getQ(selectedPrim);
            if (currQuality <= bestQuality) continue;
            bestQuality = currQuality;
            bestHouse = currHouse;
        }
        if (bestHouse == null) {
            return;
        }
        this.houseList.setSelectedValue(bestHouse, true);
        this.houseList.ensureIndexIsVisible(this.houseList.getSelectedIndex());
        this.houseModel.notifyAllListeners();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.houseList = new JList();
        this.keepOddityCheckBox = new JCheckBox();
        this.relocateButton = new JButton();
        this.streetComboBox = new JComboBox();
        this.setLayout(new GridLayout(1, 0));
        this.houseList.setModel(new AbstractListModel(){
            String[] strings = new String[]{" "};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.houseList.setSelectionMode(0);
        this.houseList.setEnabled(false);
        this.houseList.setFocusable(false);
        this.houseList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FactoryDialog.this.houseListClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.houseList);
        this.keepOddityCheckBox.setSelected(true);
        this.keepOddityCheckBox.setText("Zachov\u00e1vat sudost / lichost");
        this.keepOddityCheckBox.setEnabled(false);
        this.relocateButton.setText("Inicializovat");
        this.relocateButton.setEnabled(false);
        this.relocateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FactoryDialog.this.relocateButtonActionPerformed(evt);
            }
        });
        this.streetComboBox.setModel(this.streetModel);
        this.streetComboBox.setEnabled(false);
        this.streetComboBox.setFocusable(false);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.streetComboBox, 0, 199, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.relocateButton)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.keepOddityCheckBox, -1, 278, Short.MAX_VALUE).addContainerGap()).addComponent(this.jScrollPane1, -1, 290, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.streetComboBox, -2, -1, -2).addComponent(this.relocateButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 125, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keepOddityCheckBox)));
        this.add(this.mainPanel);
    }

    private void relocateButtonActionPerformed(ActionEvent evt) {
        CzechAddressPlugin.changeLocation();
    }

    private void houseListClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && evt.getButton() == 1) {
            Reasoner r = Reasoner.getInstance();
            if (r.translate(this.getSelectedHouse()) != null) {
                MapUtils.zoomTo(r.translate(this.getSelectedHouse()));
            } else {
                ConflictResolver.getInstance().focusElement(this.getSelectedHouse());
            }
        }
    }

    @Override
    public void elementChanged(AddressElement elem) {
        this.houseModel.notifyAllListeners();
    }

    @Override
    public void primitiveChanged(OsmPrimitive prim) {
    }

    @Override
    public void resonerReseted() {
    }

    private class HouseListModel
    extends HalfCookedListModel
    implements ReasonerListener {
        public HouseListModel() {
            Reasoner.getInstance().addListener(this);
        }

        public int getSize() {
            if (FactoryDialog.this.streetComboBox.getSelectedItem() == null) {
                return 0;
            }
            ElementWithHouses selected = (ElementWithHouses)FactoryDialog.this.streetComboBox.getSelectedItem();
            return selected.getHouses().size();
        }

        public House getHouseAt(int index) {
            if (FactoryDialog.this.streetComboBox.getSelectedItem() == null) {
                return null;
            }
            ElementWithHouses selected = (ElementWithHouses)FactoryDialog.this.streetComboBox.getSelectedItem();
            if (index < 0 || index >= selected.getHouses().size()) {
                return null;
            }
            return selected.getHouses().get(index);
        }

        public Object getElementAt(int index) {
            return this.getHouseAt(index);
        }

        public void primitiveChanged(OsmPrimitive prim) {
        }

        public void elementChanged(AddressElement elem) {
            this.notifyAllListeners();
        }

        public void resonerReseted() {
            this.notifyAllListeners();
        }
    }

    private class StreetListModel
    extends HalfCookedComboBoxModel {
        private ElementWithHouses selected = null;
        private ElementWithStreets parent = null;
        private List<ElementWithHouses> metaElem = new ArrayList<ElementWithHouses>();

        public StreetListModel() {
            this.metaElem.add(null);
            this.metaElem.add(new AllStreetProvider());
            this.metaElem.add(new FreeStreetProvider());
        }

        public int getSize() {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getStreets().size() + this.metaElem.size();
        }

        public void setParent(ElementWithStreets parent) {
            if (parent == null) {
                return;
            }
            this.selected = parent;
            this.parent = parent;
            this.metaElem.set(0, parent);
            this.metaElem.get(1).setHouses(parent.getAllHouses());
            this.notifyAllListeners();
        }

        public Object getElementAt(int index) {
            if (this.parent == null) {
                return null;
            }
            if (index < this.metaElem.size()) {
                return this.metaElem.get(index);
            }
            if ((index -= this.metaElem.size()) < this.parent.getStreets().size()) {
                return this.parent.getStreets().get(index);
            }
            return null;
        }

        public void setSelectedItem(Object anItem) {
            assert (anItem instanceof ElementWithHouses);
            this.selected = (ElementWithHouses)anItem;
            FactoryDialog.this.houseModel.notifyAllListeners();
        }

        public Object getSelectedItem() {
            return this.selected;
        }
    }

    private class FreeStreetProvider
    extends ElementWithHouses
    implements ReasonerListener {
        public FreeStreetProvider() {
            super("nep\u0159i\u0159azen\u00e9 domy");
            Reasoner.getInstance().addListener(this);
        }

        public void resonerReseted() {
            this.houses.clear();
        }

        public void primitiveChanged(OsmPrimitive prim) {
        }

        public void elementChanged(AddressElement elem) {
            if (!(elem instanceof House)) {
                return;
            }
            House house = (House)elem;
            int index = Collections.binarySearch(this.houses, house);
            if (Reasoner.getInstance().translate(house) != null) {
                if (index >= 0) {
                    this.houses.remove(index);
                }
            } else if (index < 0) {
                this.houses.add(-index - 1, house);
            }
            FactoryDialog.this.houseModel.notifyAllListeners();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllStreetProvider
    extends ElementWithHouses {
        public AllStreetProvider() {
            super("v\u0161echny domy");
        }

        @Override
        public void setHouses(List<House> houses) {
            this.houses = houses;
        }
    }

    private class HouseListRenderer
    extends DefaultListCellRenderer {
        Font plainFont = null;
        Font boldFont = null;
        ImageIcon envelopeNormIcon = ImageProvider.get((String)"envelope-closed-small.png");
        ImageIcon envelopeStarIcon = ImageProvider.get((String)"envelope-closed-star-small.png");
        ImageIcon envelopeExclIcon = ImageProvider.get((String)"envelope-closed-exclamation-small.png");

        private HouseListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this.plainFont == null) {
                this.plainFont = this.getFont().deriveFont(0);
            }
            if (this.boldFont == null) {
                this.boldFont = this.getFont().deriveFont(1);
            }
            if (value instanceof House) {
                House house = (House)value;
                this.setIcon(this.envelopeNormIcon);
                this.setFont(this.plainFont);
                if (Reasoner.getInstance().inConflict(house)) {
                    this.setIcon(this.envelopeExclIcon);
                } else if (Reasoner.getInstance().translate(house) == null) {
                    this.setIcon(this.envelopeStarIcon);
                    this.setFont(this.boldFont);
                }
                this.setText(house.getName());
            }
            return c;
        }
    }

    private class StreetListRenderer
    extends DefaultListCellRenderer {
        private StreetListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Street) {
                this.setFont(this.getFont().deriveFont(0));
                this.setText(((Street)value).getName());
            } else if (value instanceof ElementWithHouses) {
                this.setFont(this.getFont().deriveFont(1));
                this.setText("[" + ((ElementWithHouses)value).getName() + "]");
            }
            return c;
        }
    }
}

