/*
 * Decompiled with CFR 0.152.
 */
package pdfimport;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Properties;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.I18n;
import pdfimport.PathOptimizer;

public class FilePlacement {
    public Projection projection = null;
    public double minX = 0.0;
    public double maxX = 1.0;
    public double minY = 0.0;
    public double maxY = 1.0;
    public double minEast = 0.0;
    public double maxEast = 10000.0;
    public double minNorth = 0.0;
    public double maxNorth = 10000.0;
    private AffineTransform transform;
    EastNorth en = new EastNorth(0.0, 0.0);
    Point2D src = new Point2D.Double();

    public void setPdfBounds(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public void setEastNorthBounds(double minEast, double minNorth, double maxEast, double maxNorth) {
        this.minEast = minEast;
        this.maxEast = maxEast;
        this.minNorth = minNorth;
        this.maxNorth = maxNorth;
    }

    public Properties toProperties() {
        Properties p = new Properties();
        if (this.projection != null) {
            p.setProperty("Projection", this.projection.getClass().getCanonicalName());
        }
        p.setProperty("minX", Double.toString(this.minX));
        p.setProperty("maxX", Double.toString(this.maxX));
        p.setProperty("minY", Double.toString(this.minY));
        p.setProperty("maxY", Double.toString(this.maxY));
        p.setProperty("minEast", Double.toString(this.minEast));
        p.setProperty("maxEast", Double.toString(this.maxEast));
        p.setProperty("minNorth", Double.toString(this.minNorth));
        p.setProperty("maxNorth", Double.toString(this.maxNorth));
        return p;
    }

    public void fromProperties(Properties p) {
        String className = p.getProperty("Projection", null);
        this.projection = null;
        if (className != null) {
            for (Projection proj : Projection.allProjections) {
                if (!proj.getClass().getCanonicalName().equals(className)) continue;
                this.projection = proj;
                break;
            }
        }
        this.minX = this.parseProperty(p, "minX", this.minX);
        this.maxX = this.parseProperty(p, "maxX", this.maxX);
        this.minY = this.parseProperty(p, "minY", this.minY);
        this.maxY = this.parseProperty(p, "maxY", this.maxY);
        this.minEast = this.parseProperty(p, "minEast", this.minEast);
        this.maxEast = this.parseProperty(p, "maxEast", this.maxEast);
        this.minNorth = this.parseProperty(p, "minNorth", this.minNorth);
        this.maxNorth = this.parseProperty(p, "maxNorth", this.maxNorth);
    }

    private double parseProperty(Properties p, String name, double defaultValue) {
        if (!p.containsKey(name)) {
            return defaultValue;
        }
        String value = p.getProperty(name);
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String prepareTransform() {
        if (this.minX > this.maxX) {
            return I18n.tr((String)"Transform error: Min X must be smaller than max");
        }
        if (this.minY > this.maxY) {
            return I18n.tr((String)"Transform error: Min Y must be smaller than max");
        }
        if (Math.abs(this.minY - this.maxY) < 1.0 && Math.abs(this.minX - this.maxX) < 1.0) {
            return I18n.tr((String)"Transform error: Points too close");
        }
        if (Math.abs(this.minX - this.maxX) < 1.0) {
            if (this.minEast == this.maxEast) {
                this.maxX = this.minX + this.maxY - this.minY;
                this.maxEast = this.minEast + this.maxNorth - this.minNorth;
            } else {
                if (this.minNorth != this.maxNorth) return I18n.tr((String)"Transform error: Unsupported variant.");
                this.maxX = this.minX + this.maxY - this.minY;
                this.maxNorth = this.minNorth - (this.maxEast - this.minEast);
            }
        } else if (Math.abs(this.minY - this.maxY) < 1.0) {
            if (this.minNorth == this.maxNorth) {
                this.maxY = this.minY + this.maxX - this.minX;
                this.maxNorth = this.minNorth + this.maxEast - this.minEast;
            } else {
                if (this.minEast != this.maxEast) return I18n.tr((String)"Transform error: Unsupported variant.");
                this.maxY = this.minY + this.maxX - this.minX;
                this.maxEast = this.minEast - (this.maxNorth - this.minNorth);
            }
        }
        if (this.minEast < this.maxEast && this.minNorth < this.maxNorth) {
            this.transform = new AffineTransform();
            this.transform.translate(this.minEast, this.minNorth);
            this.transform.scale((this.maxEast - this.minEast) / (this.maxX - this.minX), (this.maxNorth - this.minNorth) / (this.maxY - this.minY));
            this.transform.translate(-this.minX, -this.minY);
            return null;
        } else if (this.minEast > this.maxEast && this.minNorth < this.maxNorth) {
            this.transform = new AffineTransform();
            this.transform.preConcatenate(AffineTransform.getTranslateInstance(-this.minX, -this.minY));
            this.transform.preConcatenate(AffineTransform.getScaleInstance(1.0 / (this.maxX - this.minX), 1.0 / (this.maxY - this.minY)));
            this.transform.preConcatenate(AffineTransform.getQuadrantRotateInstance(1, 0.0, 0.0));
            this.transform.preConcatenate(AffineTransform.getScaleInstance(this.minEast - this.maxEast, this.maxNorth - this.minNorth));
            this.transform.preConcatenate(AffineTransform.getTranslateInstance(this.minEast, this.minNorth));
            return null;
        } else {
            if (!(this.minEast < this.maxEast) || !(this.minNorth > this.maxNorth)) return I18n.tr((String)"Transform error: Unsupported orientation");
            this.transform = new AffineTransform();
            this.transform.preConcatenate(AffineTransform.getTranslateInstance(-this.minX, -this.minY));
            this.transform.preConcatenate(AffineTransform.getScaleInstance(1.0 / (this.maxX - this.minX), 1.0 / (this.maxY - this.minY)));
            this.transform.preConcatenate(AffineTransform.getQuadrantRotateInstance(-1, 0.0, 0.0));
            this.transform.preConcatenate(AffineTransform.getScaleInstance(this.maxEast - this.minEast, this.minNorth - this.maxNorth));
            this.transform.preConcatenate(AffineTransform.getTranslateInstance(this.minEast, this.minNorth));
        }
        return null;
    }

    public Bounds getWorldBounds(PathOptimizer data) {
        LatLon min = this.tranformCoords(new Point2D.Double(data.bounds.getMinX(), data.bounds.getMinY()));
        LatLon max = this.tranformCoords(new Point2D.Double(data.bounds.getMaxX(), data.bounds.getMaxY()));
        return new Bounds(min, max);
    }

    public LatLon tranformCoords(Point2D pt) {
        if (this.projection == null) {
            return new LatLon(pt.getY() / 1000.0, pt.getX() / 1000.0);
        }
        this.transform.transform(pt, (Point2D)this.en);
        return this.projection.eastNorth2latlon(this.en);
    }

    public EastNorth reverseTransform(LatLon coor) {
        if (this.projection == null) {
            return new EastNorth(coor.lon() * 1000.0, coor.lat() * 1000.0);
        }
        return null;
    }
}

