/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.JMenu;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.ImportImagePlugin.LoadImageAction;
import org.openstreetmap.josm.plugins.ImportImagePlugin.PluginOperations;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;

public class ImportImagePlugin
extends Plugin {
    private static Logger logger;
    JMenu mainmenu = null;
    JosmAction loadFileAction = null;
    static ClassLoader pluginClassLoader;
    static Properties pluginProps;
    static final String PLUGIN_DIR;
    static final String PLUGINPROPERTIES_PATH;
    static final String PLUGINLIBRARIES_DIR;
    static final String PLUGINPROPERTIES_FILENAME = "pluginProperties.properties";
    static final String LOGGING_PROPERTIES_FILEPATH;

    public Properties getPluginProps() {
        return pluginProps;
    }

    public ImportImagePlugin(PluginInformation info) {
        super(info);
        try {
            pluginClassLoader = this.createPluginClassLoader();
            this.initializeLogger(pluginClassLoader);
            this.checkInstallation();
            if (pluginProps == null || pluginProps.isEmpty()) {
                pluginProps = new Properties();
                pluginProps.load(new File(PLUGINPROPERTIES_PATH).toURI().toURL().openStream());
                logger.debug("Plugin properties loaded");
            }
            URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            String[] libraryNames = pluginProps.getProperty("libraries").split(",");
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (int i = 0; i < libraryNames.length; ++i) {
                File library = new File(PLUGINLIBRARIES_DIR + "/" + libraryNames[i]);
                method.invoke((Object)sysLoader, library.toURI().toURL());
            }
            PluginOperations.loadCRSData(pluginProps);
            LoadImageAction loadFileAction = new LoadImageAction();
            loadFileAction.setEnabled(true);
            Main.main.menu.fileMenu.insert((Action)((Object)loadFileAction), 8);
            Main.main.menu.fileMenu.insertSeparator(9);
        }
        catch (Exception e) {
            logger.fatal("Error while loading plugin", e);
            try {
                throw e;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        logger.info("Plugin successfully loaded.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInstallation() throws IOException {
        boolean isInstalled = true;
        if (!(new File(PLUGINPROPERTIES_PATH).exists() && new File(PLUGIN_DIR).exists() && new File(PLUGINLIBRARIES_DIR).exists())) {
            isInstalled = false;
        }
        if (!isInstalled) {
            URL propertiesURL;
            FileWriter fw;
            File libDir;
            File pluginDir = new File(PLUGIN_DIR);
            if (!pluginDir.exists()) {
                pluginDir.mkdir();
            }
            if (!(libDir = new File(PLUGINLIBRARIES_DIR)).exists()) {
                libDir.mkdir();
            }
            if (pluginProps == null || pluginProps.isEmpty()) {
                fw = new FileWriter(new File(PLUGINPROPERTIES_PATH));
                propertiesURL = pluginClassLoader.getResource("resources/pluginProperties.properties");
                pluginProps = new Properties();
                pluginProps.load(propertiesURL.openStream());
                pluginProps.store(fw, null);
                fw.close();
                logger.debug("Plugin properties loaded");
            }
            if (!new File(LOGGING_PROPERTIES_FILEPATH).exists()) {
                fw = new FileWriter(new File(LOGGING_PROPERTIES_FILEPATH));
                propertiesURL = pluginClassLoader.getResource("resources/log4j.properties");
                Properties loggingProps = new Properties();
                loggingProps.load(propertiesURL.openStream());
                loggingProps.store(fw, null);
                fw.close();
                logger.debug("Logging properties created");
            }
            String[] libStrings = pluginProps.getProperty("libraries").split(",");
            block5: for (int i = 0; i < libStrings.length; ++i) {
                URL url = pluginClassLoader.getResource("lib/" + libStrings[i]);
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(new File(libDir, libStrings[i]));
                }
                catch (FileNotFoundException e) {
                    break;
                }
                BufferedInputStream in = null;
                try {
                    in = new BufferedInputStream(url.openStream());
                    byte[] buffer = new byte[1024];
                    while (true) {
                        int count;
                        if ((count = in.read(buffer)) == -1) {
                            continue block5;
                        }
                        out.write(buffer, 0, count);
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            logger.debug("Plugin successfully installed");
        }
    }

    private void initializeLogger(ClassLoader cl) {
        Properties props = new Properties();
        try {
            props.load(new File(LOGGING_PROPERTIES_FILEPATH).toURI().toURL().openStream());
            props.setProperty("log4j.appender.MyRoFiAppender.file", Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/" + "log.log");
            PropertyConfigurator.configure(props);
            logger = Logger.getLogger(ImportImagePlugin.class);
            logger.info("Logger successfully initialized.");
            return;
        }
        catch (IOException e) {
            System.out.println("Logging properties file not found. Using standard settings.");
            props.setProperty("log4j.rootLogger", "INFO, A");
            props.setProperty("log4j.appender.A", "org.apache.log4j.FileAppender");
            props.setProperty("log4j.appender.A.layout", "org.apache.log4j.PatternLayout ");
            props.setProperty("log4j.appender.A.layout.ConversionPattern", "%d{ISO8601} %-5p [%t] %c: %m%n");
            props.setProperty("log4j.appender.A.file", Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/" + "log.log");
            PropertyConfigurator.configure(props);
            logger = Logger.getLogger(ImportImagePlugin.class);
            logger.info("Logger successfully initialized with standard settings.");
            return;
        }
    }

    private ClassLoader createPluginClassLoader() throws MalformedURLException {
        URLClassLoader loader = null;
        loader = URLClassLoader.newInstance(new URL[]{new File(Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin.jar").toURI().toURL()}, ImportImagePlugin.class.getClassLoader());
        return loader;
    }

    static {
        PLUGIN_DIR = Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/";
        PLUGINPROPERTIES_PATH = Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/pluginProperties.properties";
        PLUGINLIBRARIES_DIR = Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/lib/";
        LOGGING_PROPERTIES_FILEPATH = Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/log4j.properties/";
    }
}

