/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SplitAreaByEmptyWayAction
extends JosmAction {
    public SplitAreaByEmptyWayAction() {
        super(I18n.tr((String)"Split area"), "splitarea.png", I18n.tr((String)"Splits an area by an untagged way."), Shortcut.registerShortcut((String)"tools:splitarea", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Split area")}), (int)83, (int)2), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selectedWays = Main.main.getCurrentDataSet().getSelectedWays();
        LinkedList<Way> newSelection = new LinkedList<Way>(Main.main.getCurrentDataSet().getSelectedWays());
        block0: for (Way area : selectedWays) {
            if (!area.isClosed()) continue;
            for (OsmPrimitive prim2 : Main.main.getCurrentDataSet().allNonDeletedPrimitives()) {
                Way border;
                if (!(prim2 instanceof Way) || prim2.equals((Object)area) || (border = (Way)prim2).getNodes().size() == 0 || border.keySet().size() > 0 || !area.getNodes().contains(border.firstNode()) || !area.getNodes().contains(border.lastNode())) continue;
                Way newArea1 = new Way();
                Way newArea2 = new Way();
                int errorCode = this.splitArea(area, border, newArea1, newArea2);
                if (errorCode == 2) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The selected area cannot be splitted, because it is a member of some relation.\nRemove the area from the relation before splitting it."));
                    continue block0;
                }
                if (errorCode != 0) continue;
                Main.main.getCurrentDataSet().addPrimitive((OsmPrimitive)newArea1);
                Main.main.getCurrentDataSet().addPrimitive((OsmPrimitive)newArea2);
                area.setDeleted(true);
                border.setDeleted(true);
                newSelection.remove(area);
                newSelection.remove(border);
                newSelection.add(newArea1);
                newSelection.add(newArea2);
                continue block0;
            }
        }
        Main.main.getCurrentDataSet().setSelected(newSelection);
    }

    private int splitArea(Way area, Way border, Way newArea1, Way newArea2) {
        int index2;
        for (Relation r : Main.main.getCurrentDataSet().getRelations()) {
            for (RelationMember rm : r.getMembers()) {
                if (!rm.refersTo((OsmPrimitive)area) && !rm.refersTo((OsmPrimitive)border)) continue;
                return 2;
            }
        }
        List bordNodes = border.getNodes();
        List areaNodes = area.getNodes();
        int index1 = areaNodes.indexOf(bordNodes.get(0));
        if (index1 == (index2 = areaNodes.indexOf(bordNodes.get(bordNodes.size() - 1)))) {
            return 1;
        }
        if (index1 > index2) {
            Collections.reverse(areaNodes);
            index1 = areaNodes.indexOf(bordNodes.get(0));
            index2 = areaNodes.indexOf(bordNodes.get(bordNodes.size() - 1));
        }
        for (String key : area.keySet()) {
            newArea1.put(key, area.get(key));
            newArea2.put(key, area.get(key));
        }
        List newNodeList1 = newArea1.getNodes();
        List newNodeList2 = newArea1.getNodes();
        newNodeList1.addAll(areaNodes.subList(0, index1));
        newNodeList1.addAll(bordNodes);
        newNodeList1.addAll(areaNodes.subList(index2 + 1, areaNodes.size()));
        Collections.reverse(bordNodes);
        newNodeList2.addAll(areaNodes.subList(index1, index2));
        newNodeList2.addAll(bordNodes);
        newArea1.setNodes(newNodeList1);
        newArea2.setNodes(newNodeList2);
        return 0;
    }
}

