/*
 * Decompiled with CFR 0.152.
 */
package pdfimport;

import java.awt.geom.Point2D;
import java.util.List;
import pdfimport.LayerContents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfPath {
    public List<Point2D> points;
    public double length;
    LayerContents layer;
    public int nr;

    public PdfPath(List<Point2D> nodes) {
        this.points = nodes;
    }

    public boolean isClosed() {
        return this.points.size() > 1 && this.points.get(0) == this.points.get(this.points.size() - 1);
    }

    public Point2D firstPoint() {
        return this.points.get(0);
    }

    public Point2D lastPoint() {
        return this.points.get(this.points.size() - 1);
    }

    public void calculateLength() {
        double len = 0.0;
        for (int pos = 1; pos < this.points.size(); ++pos) {
            len += this.points.get(pos).distance(this.points.get(pos - 1));
        }
        this.length = len;
    }

    public Point2D getOtherEnd(Point2D endPoint) {
        if (this.firstPoint() == endPoint) {
            return this.lastPoint();
        }
        if (this.lastPoint() == endPoint) {
            return this.firstPoint();
        }
        throw new RuntimeException("Unexpected point");
    }
}

