/*
 * Decompiled with CFR 0.152.
 */
package sk.zdila.josm.plugin.simplify;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyAreaAction
extends JosmAction {
    private static final long serialVersionUID = 6854238214548011750L;
    public static double R = 6378135.0;

    public SimplifyAreaAction() {
        super(I18n.tr((String)"Simplify Area"), "simplify", I18n.tr((String)"Delete unnecessary nodes from an area."), Shortcut.registerShortcut((String)"tools:simplifyArea", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Simplify Area")}), (int)65, (int)3, (int)1), true);
    }

    private List<Bounds> getCurrentEditBounds() {
        LinkedList<Bounds> bounds = new LinkedList<Bounds>();
        OsmDataLayer dataLayer = Main.map.mapView.getEditLayer();
        for (DataSource ds : dataLayer.data.dataSources) {
            if (ds.bounds == null) continue;
            bounds.add(ds.bounds);
        }
        return bounds;
    }

    private boolean isInBounds(Node node, List<Bounds> bounds) {
        for (Bounds b : bounds) {
            if (!b.contains(node.getCoor())) continue;
            return true;
        }
        return false;
    }

    private boolean confirmWayWithNodesOutsideBoundingBox() {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Yes, delete nodes"), (Icon)ImageProvider.get((String)"ok"), I18n.tr((String)"Delete nodes outside of downloaded data regions"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"No, abort"), (Icon)ImageProvider.get((String)"cancel"), I18n.tr((String)"Cancel operation"), null)};
        int ret = HelpAwareOptionPane.showOptionDialog((Component)Main.parent, (Object)("<html>" + I18n.trn((String)"The selected way has nodes outside of the downloaded data region.", (String)"The selected ways have nodes outside of the downloaded data region.", (long)SimplifyAreaAction.getCurrentDataSet().getSelectedWays().size()) + "<br>" + I18n.tr((String)"This can lead to nodes being deleted accidentally.") + "<br>" + I18n.tr((String)"Do you want to delete them anyway?") + "</html>"), (String)I18n.tr((String)"Delete nodes outside of data regions?"), (int)2, null, (HelpAwareOptionPane.ButtonSpec[])options, (HelpAwareOptionPane.ButtonSpec)options[0], null);
        return ret == 0;
    }

    private void alertSelectAtLeastOneWay() {
        HelpAwareOptionPane.showOptionDialog((Component)Main.parent, (Object)I18n.tr((String)"Please select at least one way to simplify."), (String)I18n.tr((String)"Warning"), (int)2, null);
    }

    private boolean confirmSimplifyManyWays(int numWays) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Yes"), (Icon)ImageProvider.get((String)"ok"), I18n.tr((String)"Simplify all selected ways"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Cancel"), (Icon)ImageProvider.get((String)"cancel"), I18n.tr((String)"Cancel operation"), null)};
        int ret = HelpAwareOptionPane.showOptionDialog((Component)Main.parent, (Object)I18n.tr((String)"The selection contains {0} ways. Are you sure you want to simplify them all?", (Object[])new Object[]{numWays}), (String)I18n.tr((String)"Simplify ways?"), (int)2, null, (HelpAwareOptionPane.ButtonSpec[])options, (HelpAwareOptionPane.ButtonSpec)options[0], null);
        return ret == 0;
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = SimplifyAreaAction.getCurrentDataSet().getSelected();
        List<Bounds> bounds = this.getCurrentEditBounds();
        block0: for (OsmPrimitive prim : selection) {
            if (!(prim instanceof Way) || bounds.size() <= 0) continue;
            Way way = (Way)prim;
            for (Node node : way.getNodes()) {
                if (this.isInBounds(node, bounds)) continue;
                if (this.confirmWayWithNodesOutsideBoundingBox()) continue block0;
                return;
            }
        }
        List ways = OsmPrimitive.getFilteredList((Collection)selection, Way.class);
        if (ways.isEmpty()) {
            this.alertSelectAtLeastOneWay();
            return;
        }
        if (ways.size() > 10 && !this.confirmSimplifyManyWays(ways.size())) {
            return;
        }
        LinkedList<SequenceCommand> allCommands = new LinkedList<SequenceCommand>();
        for (Way way : ways) {
            SequenceCommand simplifyCommand = this.simplifyWay(way);
            if (simplifyCommand == null) continue;
            allCommands.add(simplifyCommand);
        }
        if (!allCommands.isEmpty()) {
            SequenceCommand rootCommand = new SequenceCommand(I18n.trn((String)"Simplify {0} way", (String)"Simplify {0} ways", (long)allCommands.size(), (Object[])new Object[]{allCommands.size()}), allCommands);
            Main.main.undoRedo.add((Command)rootCommand);
            Main.map.repaint();
        }
    }

    private boolean isRequiredNode(Way way, Node node) {
        LinkedList parents = new LinkedList(node.getReferrers());
        parents.remove(way);
        return !parents.isEmpty() || node.isTagged();
    }

    private SequenceCommand simplifyWay(Way w) {
        int len;
        double angleThreshold = Main.pref.getDouble("simplify-area.angle.threshold", 10.0);
        double angleFactor = Main.pref.getDouble("simplify-area.angle.factor", 1.0);
        double mergeThreshold = Main.pref.getDouble("simplify-area.merge.threshold", 0.2);
        double areaThreshold = Main.pref.getDouble("simplify-area.area.threshold", 5.0);
        double areaFactor = Main.pref.getDouble("simplify-area.area.factor", 1.0);
        double distanceThreshold = Main.pref.getDouble("simplify-area.dist.threshold", 3.0);
        double distanceFactor = Main.pref.getDouble("simplify-area.dist.factor", 3.0);
        List nodes = w.getNodes();
        int size = nodes.size();
        if (size == 0) {
            return null;
        }
        boolean closed = ((Node)nodes.get(0)).equals(nodes.get(size - 1));
        if (closed) {
            nodes.remove(size - 1);
        }
        while (true) {
            Node prevNode = null;
            LatLon coord1 = null;
            LatLon coord2 = null;
            double minWeight = Double.MAX_VALUE;
            Node bestMatch = null;
            len = nodes.size() + (closed ? 2 : 1);
            for (int i = 0; i < len; ++i) {
                Node n = (Node)nodes.get(i % nodes.size());
                LatLon coord3 = n.getCoor();
                if (coord1 != null) {
                    double weight;
                    double angleWeight = SimplifyAreaAction.computeConvectAngle(coord1, coord2, coord3) / angleThreshold;
                    double areaWeight = SimplifyAreaAction.computeArea(coord1, coord2, coord3) / areaThreshold;
                    double distanceWeight = Math.abs(SimplifyAreaAction.crossTrackError(coord1, coord2, coord3)) / distanceThreshold;
                    double d = weight = this.isRequiredNode(w, prevNode) || !closed && i == len - 1 || angleWeight > 1.0 || areaWeight > 1.0 || distanceWeight > 1.0 ? Double.MAX_VALUE : angleWeight * angleFactor + areaWeight * areaFactor + distanceWeight * distanceFactor;
                    if (weight < minWeight) {
                        minWeight = weight;
                        bestMatch = prevNode;
                    }
                }
                coord1 = coord2;
                coord2 = coord3;
                prevNode = n;
            }
            if (bestMatch == null) break;
            nodes.remove(bestMatch);
        }
        HashMap<Node, LatLon> coordMap = new HashMap<Node, LatLon>();
        for (Node n : nodes) {
            coordMap.put(n, n.getCoor());
        }
        HashMap<Node, MoveCommand> moveCommandList = new HashMap<Node, MoveCommand>();
        while (true) {
            double minDist = Double.MAX_VALUE;
            Node node1 = null;
            Node node2 = null;
            len = nodes.size() + (closed ? 2 : 1);
            for (int i = 0; i < len; ++i) {
                double dist;
                Node n1 = (Node)nodes.get(i % nodes.size());
                Node n2 = (Node)nodes.get((i + 1) % nodes.size());
                if (this.isRequiredNode(w, n1) || this.isRequiredNode(w, n2) || !((dist = ((LatLon)coordMap.get(n1)).greatCircleDistance((LatLon)coordMap.get(n2))) < minDist) || !(dist < mergeThreshold)) continue;
                minDist = dist;
                node1 = n1;
                node2 = n2;
            }
            if (node1 == null || node2 == null) break;
            LatLon coord = ((LatLon)coordMap.get(node1)).getCenter((LatLon)coordMap.get(node2));
            coordMap.put(node1, coord);
            moveCommandList.put(node1, new MoveCommand(node1, coord));
            nodes.remove(node2);
            coordMap.remove(node2);
            moveCommandList.remove(node2);
        }
        if (closed) {
            nodes.add(nodes.get(0));
        }
        HashSet delNodes = new HashSet(w.getNodes());
        delNodes.removeAll(nodes);
        if (delNodes.isEmpty()) {
            return null;
        }
        LinkedList<Object> cmds = new LinkedList<Object>();
        Way newWay = new Way(w);
        newWay.setNodes(nodes);
        cmds.addAll(moveCommandList.values());
        cmds.add(new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)newWay));
        cmds.add(new DeleteCommand(delNodes));
        return new SequenceCommand(I18n.trn((String)"Simplify Area (remove {0} node)", (String)"Simplify Area (remove {0} nodes)", (long)delNodes.size(), (Object[])new Object[]{delNodes.size()}), cmds);
    }

    public static double computeConvectAngle(LatLon coord1, LatLon coord2, LatLon coord3) {
        double angle = Math.abs(SimplifyAreaAction.heading(coord2, coord3) - SimplifyAreaAction.heading(coord1, coord2));
        return Math.toDegrees(angle < Math.PI ? angle : Math.PI * 2 - angle);
    }

    public static double computeArea(LatLon coord1, LatLon coord2, LatLon coord3) {
        double c;
        double b;
        double a = coord1.greatCircleDistance(coord2);
        double p = (a + (b = coord2.greatCircleDistance(coord3)) + (c = coord3.greatCircleDistance(coord1))) / 2.0;
        double q = p * (p - a) * (p - b) * (p - c);
        return q < 0.0 ? 0.0 : Math.sqrt(q);
    }

    public static double crossTrackError(LatLon l1, LatLon l2, LatLon l3) {
        return R * Math.asin(Math.sin(l1.greatCircleDistance(l2) / R) * Math.sin(SimplifyAreaAction.heading(l1, l2) - SimplifyAreaAction.heading(l1, l3)));
    }

    public static double heading(LatLon a, LatLon b) {
        double hd = Math.atan2(Math.sin(Math.toRadians(a.lon() - b.lon())) * Math.cos(Math.toRadians(b.lat())), Math.cos(Math.toRadians(a.lat())) * Math.sin(Math.toRadians(b.lat())) - Math.sin(Math.toRadians(a.lat())) * Math.cos(Math.toRadians(b.lat())) * Math.cos(Math.toRadians(a.lon() - b.lon())));
        if ((hd %= Math.PI * 2) < 0.0) {
            hd += Math.PI * 2;
        }
        return hd;
    }

    protected void updateEnabledState() {
        if (SimplifyAreaAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SimplifyAreaAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

