/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.renderer;

import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustAction;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustComment;
import org.openstreetmap.josm.tools.ImageProvider;

public class ActionListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
        if (value instanceof MapdustAction) {
            MapdustAction mapdustAction = (MapdustAction)value;
            String text = "";
            MapdustBug bug = mapdustAction.getMapdustBug();
            MapdustComment comment = mapdustAction.getMapdustComment();
            if (comment == null) {
                bug = mapdustAction.getMapdustBug();
                text = text + bug.getType().getValue() + ":";
                text = text + bug.getDescription() + " ";
                text = text + " created by ";
                text = text + bug.getNickname();
            } else if (mapdustAction.getNewStatus() != null) {
                switch (mapdustAction.getNewStatus()) {
                    case 1: {
                        text = text + bug.getId() + ":";
                        text = text + bug.getType().getValue() + " ";
                        text = text + " re-opened by ";
                        text = text + comment.getNickname();
                        break;
                    }
                    case 2: {
                        text = text + bug.getId() + ":";
                        text = text + bug.getType().getValue() + " ";
                        text = text + " fixed by ";
                        text = text + comment.getNickname();
                        break;
                    }
                    case 3: {
                        text = text + bug.getId() + ":";
                        text = text + bug.getType().getValue() + " ";
                        text = text + " invalidated by ";
                        text = text + comment.getNickname();
                    }
                }
            } else {
                text = text + bug.getId() + ":";
                text = text + bug.getType().getValue() + " ";
                text = text + " commented by ";
                text = text + comment.getNickname();
            }
            label.setText(text);
            label.setIcon(ImageProvider.get((String)mapdustAction.getIconPath()));
            label.setFont(new Font("Times New Roman", 1, 12));
        }
        return label;
    }
}

