/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.panel;

import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteRefresh;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteWorkOffline;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.MapdustShowAction;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.ShowCloseBugAction;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.ShowCommentBugAction;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.ShowInvalidateBugAction;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.ShowReOpenBugAction;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;

public class MapdustButtonPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JToggleButton btnWorkOffline;
    private JToggleButton btnRefresh;
    private JToggleButton btnAddComment;
    private JToggleButton btnFixBugReport;
    private JToggleButton btnInvalidateBugReport;
    private JToggleButton btnReOpenBugReport;

    public MapdustButtonPanel() {
    }

    public MapdustButtonPanel(MapdustPlugin mapdustPlugin) {
        this.setLayout(new GridLayout(1, 7));
        this.addComponents(mapdustPlugin);
    }

    private void addComponents(MapdustPlugin mapdustPlugin) {
        MapdustShowAction action;
        String pluginState;
        if (this.btnWorkOffline == null) {
            pluginState = Main.pref.get("mapdust.pluginState");
            String tooltipText = "";
            String imagePath = "";
            if (pluginState.equals(MapdustPluginState.ONLINE.getValue())) {
                tooltipText = "Work offline mode";
                imagePath = "dialogs/workoffline.png";
            } else {
                tooltipText = "Work online mode";
                imagePath = "dialogs/online.png";
            }
            ExecuteWorkOffline action2 = new ExecuteWorkOffline(mapdustPlugin.getMapdustGUI());
            action2.addObserver(mapdustPlugin);
            this.btnWorkOffline = ComponentUtil.createJButton("Work offline", tooltipText, imagePath, action2);
        }
        if (this.btnRefresh == null) {
            pluginState = Main.pref.get("mapdust.pluginState");
            ExecuteRefresh action3 = new ExecuteRefresh();
            action3.addObserver(mapdustPlugin);
            this.btnRefresh = ComponentUtil.createJButton("Refresh", "Refresh", "dialogs/refresh.png", action3);
            if (pluginState.equals(MapdustPluginState.OFFLINE.getValue())) {
                this.btnRefresh.setEnabled(false);
            }
        }
        if (this.btnAddComment == null) {
            action = new ShowCommentBugAction(mapdustPlugin);
            this.btnAddComment = ComponentUtil.createJButton("Comment bug report", "Comment bug report", "dialogs/comment.png", action);
            this.btnAddComment.setEnabled(false);
        }
        if (this.btnFixBugReport == null) {
            action = new ShowCloseBugAction(mapdustPlugin);
            this.btnFixBugReport = ComponentUtil.createJButton("Close bug report", "Close bug report", "dialogs/fixed.png", action);
            this.btnFixBugReport.setEnabled(false);
        }
        if (this.btnInvalidateBugReport == null) {
            action = new ShowInvalidateBugAction(mapdustPlugin);
            this.btnInvalidateBugReport = ComponentUtil.createJButton("Invalidate bug report", "Invalidate bug report", "dialogs/invalid.png", action);
            this.btnInvalidateBugReport.setEnabled(false);
        }
        if (this.btnReOpenBugReport == null) {
            action = new ShowReOpenBugAction(mapdustPlugin);
            this.btnReOpenBugReport = ComponentUtil.createJButton("Re-open bug report", "Re-open bug report", "dialogs/reopen.png", action);
            this.btnReOpenBugReport.setEnabled(false);
        }
        this.add(this.btnWorkOffline);
        this.add(this.btnRefresh);
        this.add(this.btnAddComment);
        this.add(this.btnFixBugReport);
        this.add(this.btnInvalidateBugReport);
        this.add(this.btnReOpenBugReport);
    }

    public JToggleButton getBtnWorkOffline() {
        return this.btnWorkOffline;
    }

    public JToggleButton getBtnRefresh() {
        return this.btnRefresh;
    }

    public JToggleButton getBtnAddComment() {
        return this.btnAddComment;
    }

    public JToggleButton getBtnFixBugReport() {
        return this.btnFixBugReport;
    }

    public JToggleButton getBtnInvalidateBugReport() {
        return this.btnInvalidateBugReport;
    }

    public JToggleButton getBtnReOpenBugReport() {
        return this.btnReOpenBugReport;
    }
}

