/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.panel;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.service.value.Address;

public class MapdustAddressPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public MapdustAddressPanel(Address address, LatLon coordinates) {
        this.setLayout(new GridLayout(8, 1));
        this.setBackground(Color.white);
        this.addComponents(address, coordinates);
    }

    private void addComponents(Address address, LatLon coordinates) {
        Font fontLabel = new Font("Times New Roman", 1, 12);
        Font fontLabelVal = new Font("Times New Roman", 0, 12);
        this.add(ComponentUtil.createJLabel("Country: ", fontLabel, null));
        String country = address != null ? address.getCountryCode() : "";
        this.add(ComponentUtil.createJLabel(country, fontLabelVal, null));
        this.add(ComponentUtil.createJLabel("City: ", fontLabel, null));
        String city = address != null ? address.getCity() : "";
        this.add(ComponentUtil.createJLabel(city, fontLabelVal, null));
        this.add(ComponentUtil.createJLabel("State code: ", fontLabel, null));
        String state = address != null ? address.getStateCode() : "";
        this.add(ComponentUtil.createJLabel(state, fontLabelVal, null));
        this.add(ComponentUtil.createJLabel("Zip code: ", fontLabel, null));
        String zip = address != null ? address.getZipCode() : "";
        this.add(ComponentUtil.createJLabel(zip, fontLabelVal, null));
        this.add(ComponentUtil.createJLabel("Street: ", fontLabel, null));
        String street = address != null ? address.getStreetName() : "";
        this.add(ComponentUtil.createJLabel(street, fontLabelVal, null));
        this.add(ComponentUtil.createJLabel("House number: ", fontLabel, null));
        String houseNr = address != null ? address.getHouseNumber() : "";
        this.add(ComponentUtil.createJLabel(houseNr, fontLabelVal, null));
        this.add(ComponentUtil.createJLabel("Latitude: ", fontLabel, null));
        String lat = coordinates != null ? "" + coordinates.lat() : "";
        this.add(ComponentUtil.createJLabel(lat, fontLabelVal, null));
        this.add(ComponentUtil.createJLabel("Longitude: ", fontLabel, null));
        String lon = coordinates != null ? "" + coordinates.lon() : "";
        this.add(ComponentUtil.createJLabel(lon, fontLabelVal, null));
    }
}

