/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.action.execute;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustGUI;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.MapdustExecuteAction;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.ChangeIssueStatusDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustActionListObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustActionListObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustAction;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustServiceCommand;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandler;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandlerException;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustComment;
import org.openstreetmap.josm.plugins.mapdust.service.value.Status;
import org.openstreetmap.josm.tools.I18n;

public class ExecuteCloseBug
extends MapdustExecuteAction
implements MapdustBugObservable,
MapdustActionListObservable {
    private static final long serialVersionUID = 1L;
    private final ArrayList<MapdustBugObserver> bugObservers = new ArrayList();
    private final ArrayList<MapdustActionListObserver> actionObservers = new ArrayList();

    public ExecuteCloseBug() {
    }

    public ExecuteCloseBug(ChangeIssueStatusDialog dialog, MapdustGUI mapdustGUI) {
        this.setDialog(dialog);
        this.setMapdustGUI(mapdustGUI);
    }

    public void actionPerformed(ActionEvent event) {
        JButton btn;
        if (event.getSource() instanceof JButton && (btn = (JButton)event.getSource()).getText().equals("OK")) {
            String commentText;
            ChangeIssueStatusDialog issueDialog = (ChangeIssueStatusDialog)this.getDialog();
            String nickname = issueDialog.getTxtNickname().getText();
            String errorMessage = this.validate(nickname, commentText = issueDialog.getTxtDescription().getText());
            if (errorMessage != null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage), I18n.tr((String)"Missing input data"), 2);
                return;
            }
            Main.pref.put("mapdust.nickname", nickname);
            MapdustBug selectedBug = this.getSelectedBug();
            MapdustComment comment = new MapdustComment(selectedBug.getId(), commentText, nickname);
            String pluginState = Main.pref.get("mapdust.pluginState");
            if (pluginState.equals(MapdustPluginState.OFFLINE.getValue())) {
                selectedBug.setStatus(Status.FIXED);
                String iconPath = this.getIconPath(selectedBug);
                MapdustAction mapdustAction = new MapdustAction(MapdustServiceCommand.CHANGE_BUG_STATUS, iconPath, selectedBug, comment, 2);
                if (this.getMapdustGUI().getQueuePanel() != null) {
                    this.notifyObservers(mapdustAction);
                }
            } else {
                MapdustServiceHandler handler = new MapdustServiceHandler();
                Long id = null;
                try {
                    id = handler.changeBugStatus(2, comment);
                }
                catch (MapdustServiceHandlerException e) {
                    errorMessage = "There was a Mapdust service error.";
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage), I18n.tr((String)"Error"), 0);
                }
                if (id != null) {
                    MapdustBug newMapdustBug = null;
                    try {
                        newMapdustBug = handler.getBug(selectedBug.getId(), null);
                    }
                    catch (MapdustServiceHandlerException e) {
                        errorMessage = "There was a Mapdust service error.";
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage), I18n.tr((String)"Error"), 0);
                    }
                    if (newMapdustBug != null) {
                        this.notifyObservers(newMapdustBug);
                    }
                }
            }
            this.enableFiredButton(issueDialog.getFiredButton());
            this.resetSelectedBug(0);
            issueDialog.dispose();
        }
    }

    public void addObserver(MapdustBugObserver observer) {
        if (!this.bugObservers.contains(observer)) {
            this.bugObservers.add(observer);
        }
    }

    public void addObserver(MapdustActionListObserver observer) {
        if (!this.actionObservers.contains(observer)) {
            this.actionObservers.add(observer);
        }
    }

    public void removeObserver(MapdustBugObserver observer) {
        this.bugObservers.remove(observer);
    }

    public void removeObserver(MapdustActionListObserver observer) {
        this.actionObservers.remove(observer);
    }

    public void notifyObservers(MapdustBug mapdustBug) {
        Iterator<MapdustBugObserver> elements = this.bugObservers.iterator();
        while (elements.hasNext()) {
            elements.next().changedData(mapdustBug);
        }
    }

    public void notifyObservers(MapdustAction mapdustAction) {
        Iterator<MapdustActionListObserver> elements = this.actionObservers.iterator();
        while (elements.hasNext()) {
            elements.next().addAction(mapdustAction);
        }
    }
}

