/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.scripting.ScriptEngineProvider;
import org.openstreetmap.josm.plugins.scripting.preferences.PreferenceKeys;
import org.openstreetmap.josm.plugins.scripting.preferences.ScriptEngineJarInfo;

public class ScriptEngineJarTableModel
extends AbstractTableModel
implements PreferenceKeys {
    private static final Logger logger = Logger.getLogger(ScriptEngineJarTableModel.class.getName());
    private final List<ScriptEngineJarInfo> jars = new ArrayList<ScriptEngineJarInfo>();
    private DefaultListSelectionModel selectionModel;

    public ScriptEngineJarTableModel() {
        this(null);
    }

    public ScriptEngineJarTableModel(DefaultListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
        if (this.selectionModel == null) {
            this.selectionModel = new DefaultListSelectionModel();
        }
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.jars.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.jars.get(row);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            this.jars.get(row).setJarFilePath((String)value);
            this.fireTableDataChanged();
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public void restoreFromPreferences() {
        this.jars.clear();
        Collection paths = Main.pref.getCollection("scripting.engine-jars");
        if (paths != null) {
            for (String path : paths) {
                if ((path = path.trim()).isEmpty()) continue;
                this.jars.add(new ScriptEngineJarInfo(path));
            }
        }
        this.fireTableDataChanged();
    }

    public void persistToPreferences() {
        ArrayList<String> paths = new ArrayList<String>();
        for (ScriptEngineJarInfo info : this.jars) {
            String path = info.getJarFilePath();
            if ((path = path.trim()).isEmpty()) continue;
            paths.add(path);
        }
        Main.pref.putCollection("scripting.engine-jars", paths);
    }

    public void deleteSelected() {
        boolean updated = false;
        for (int i = this.jars.size() - 1; i >= 0; --i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            updated = true;
            this.jars.remove(i);
        }
        if (updated) {
            this.fireTableDataChanged();
        }
    }

    public void addNew() {
        this.jars.add(new ScriptEngineJarInfo(""));
        this.fireTableDataChanged();
    }

    @Override
    public void fireTableDataChanged() {
        super.fireTableDataChanged();
        ArrayList<File> jarfiles = new ArrayList<File>();
        for (ScriptEngineJarInfo info : this.jars) {
            String path = info.getJarFilePath();
            if ((path = path.trim()).isEmpty() || !info.getStatusMessage().equals("OK")) continue;
            jarfiles.add(new File(path));
        }
        ScriptEngineProvider.getInstance().setScriptEngineJars(jarfiles);
    }
}

